package com.biz.crm.dms.business.allow.sale.local.list.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListCacheService;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListModifyNoticeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 允销清单缓存相关: AllowSaleList: 允销清单缓存相关
 *
 * @author sunx
 * @date 2022/6/20
 */
@Slf4j
@Api(tags = "允销清单缓存相关: AllowSaleList: 允销清单缓存相关")
@RestController
@RequestMapping(value = {"/v1/allowSaleList/cache"})
public class AllowSaleListCacheController {

  @Autowired(required = false)
  private AllowSaleListCacheService allowSaleListCacheService;

  /**
   * 通知进行功能缓存的清理
   *
   * @param dto 通知信息
   * @return
   */
  @ApiOperation(value = "通知进行功能缓存的清理")
  @PostMapping(value = "/notifyCacheRefresh")
  public Result<?> notifyCacheRefresh(@RequestBody AllowSaleListModifyNoticeDto dto) {
    try {
      this.allowSaleListCacheService.notifyCacheRefresh(dto);
      return Result.ok("成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取缓存中的值
   *
   * @param listType 清单类型
   * @param businessCode 业务编码
   * @return
   */
  @ApiOperation(value = "获取缓存中的值")
  @GetMapping(value = "/findCache")
  public Result<Set<String>> findCache(
      @RequestParam("listType") String listType,
      @RequestParam("businessCode") String businessCode) {
    try {
      return Result.ok(this.allowSaleListCacheService.findCache(listType, businessCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
