package com.biz.crm.dms.business.allow.sale.local.list.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 可购规则与可购清单关系数据
 *
 * @author sunx
 * @since 2022-06-24 15:29:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_allow_sale_rule_relate_list")
@Table(
    name = "dms_allow_sale_rule_relate_list",
    indexes = {
      @Index(name = "asrrl_idx1", columnList = "tenant_code,sub_item_key", unique = true),
      @Index(name = "asrrl_idx2", columnList = "rule_code"),
      @Index(name = "asrrl_idx3", columnList = "item_key"),
    })
@ApiModel(value = "AllowSaleRuleRelateList", description = "可购规则与可购清单关系数据")
@org.hibernate.annotations.Table(
    appliesTo = "dms_allow_sale_rule_relate_list",
    comment = "可购规则与可购清单关系数据")
public class AllowSaleRuleRelateList extends UuidOpEntity {

  /** 可购规则编码 */
  @ApiModelProperty("可购规则编码")
  @TableField(value = "rule_code")
  @Column(name = "rule_code", length = 64, columnDefinition = "varchar(64) COMMENT '可购规则编码'")
  private String ruleCode;

  /** 可购清单行唯一编码 */
  @ApiModelProperty("可购清单行唯一编码")
  @TableField(value = "item_key")
  @Column(name = "item_key", length = 150, columnDefinition = "varchar(150) COMMENT '可购清单行唯一编码'")
  private String itemKey;

  /** 行唯一编码 */
  @ApiModelProperty("行唯一编码")
  @TableField(value = "sub_item_key")
  @Column(name = "sub_item_key", length = 200, columnDefinition = "varchar(200) COMMENT '行唯一编码'")
  private String subItemKey;

  /**
   * 规则类型，allow可购,not_allow不可购
   *
   * @see AllowSaleRuleTypeEnums
   */
  @ApiModelProperty("规则类型，allow可购,not_allow不可购")
  @TableField(value = "rule_type")
  @Column(
      name = "rule_type",
      length = 10,
      columnDefinition = "varchar(10) COMMENT '规则类型，allow可购,not_allow不可购'")
  private String ruleType;

  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  @TableField(value = "tenant_code")
  @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT '租户编号'")
  private String tenantCode;

  /** 清单业务类型 */
  @ApiModelProperty("清单业务类型")
  @TableField(exist = false)
  @Transient
  private String listType;

  /** 关联业务编码，经销商编码|终端编码 */
  @ApiModelProperty("关联业务编码，经销商编码|终端编码")
  @TableField(exist = false)
  @Transient
  private String businessCode;

  /** 可购商品编码 */
  @ApiModelProperty("可购商品编码")
  @TableField(exist = false)
  @Transient
  private String productCode;

  /** 行记录规则公共信息 */
  @ApiModelProperty("行记录规则公共信息")
  @TableField(exist = false)
  @Transient
  private RelateRule rule;

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AllowSaleRuleRelateList that = (AllowSaleRuleRelateList) o;
    return Objects.equals(ruleCode, that.ruleCode)
        && Objects.equals(itemKey, that.itemKey)
        && Objects.equals(tenantCode, that.tenantCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ruleCode, itemKey, tenantCode);
  }
}
