package com.biz.crm.dms.business.allow.sale.local.list.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.mapper.AllowSaleRuleRelateListMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 可购规则与可购清单关系数据(repository)
 *
 * @author sunx
 * @date 2022-06-24 15:29:38
 */
@Component
public class AllowSaleRuleRelateListRepository
    extends ServiceImpl<AllowSaleRuleRelateListMapper, AllowSaleRuleRelateList> {

  private static final Integer SPLIT_SIZE = 1000;

  /**
   * 根据itemKey集合获取关联规则数据
   *
   * @param itemKeys 行记录编码
   * @return
   */
  public List<AllowSaleRuleRelateList> findByItemKeys(Set<String> itemKeys) {
    List<AllowSaleRuleRelateList> list = Lists.newLinkedList();
    for (List<String> item : Lists.partition(Lists.newArrayList(itemKeys), SPLIT_SIZE)) {
      final List<AllowSaleRuleRelateList> cur =
          this.lambdaQuery()
              .eq(AllowSaleRuleRelateList::getTenantCode, TenantUtils.getTenantCode())
              .in(AllowSaleRuleRelateList::getItemKey, item)
              .list();
      if (CollectionUtils.isNotEmpty(cur)) {
        list.addAll(cur);
      }
    }
    return list;
  }

  /**
   * 根据subItemKey集合获取关联规则数据
   *
   * @param subItemKeys 唯一行记录编码
   * @return
   */
  public List<AllowSaleRuleRelateList> findBySubItemKeys(Set<String> subItemKeys) {
    List<AllowSaleRuleRelateList> list = Lists.newLinkedList();
    for (List<String> item : Lists.partition(Lists.newArrayList(subItemKeys), SPLIT_SIZE)) {
      final List<AllowSaleRuleRelateList> cur =
          this.lambdaQuery()
              .eq(AllowSaleRuleRelateList::getTenantCode, TenantUtils.getTenantCode())
              .in(AllowSaleRuleRelateList::getSubItemKey, item)
              .list();
      if (CollectionUtils.isNotEmpty(cur)) {
        list.addAll(cur);
      }
    }
    return list;
  }

  /**
   * 根据规则编码物理删除关联数据
   *
   * @param ruleCode 规则编码
   */
  public void deleteByRuleCode(String ruleCode) {
    LambdaQueryWrapper<AllowSaleRuleRelateList> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(AllowSaleRuleRelateList::getTenantCode, TenantUtils.getTenantCode())
        .eq(AllowSaleRuleRelateList::getRuleCode, ruleCode);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据subItemKeys删除数据
   *
   * @param subItemKeys 唯一行记录编码
   */
  public void deleteBySubItemKeys(Set<String> subItemKeys) {
    for (List<String> item : Lists.partition(Lists.newArrayList(subItemKeys), SPLIT_SIZE)) {
      LambdaQueryWrapper<AllowSaleRuleRelateList> lambdaQuery = Wrappers.lambdaQuery();
      lambdaQuery
          .eq(AllowSaleRuleRelateList::getTenantCode, TenantUtils.getTenantCode())
          .in(AllowSaleRuleRelateList::getSubItemKey, item);
      this.baseMapper.delete(lambdaQuery);
    }
  }
}
