package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListCacheService;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListModifyNoticeDto;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.listener.MessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 当功能模块收到redis订阅消息，说明当前桶下的某个进程中，已经发生了可购信息的变化。
 *
 * @author sunx
 * @date 2022/6/20
 */
@Component("_CacheRedisMessageForAllowSaleListListenerImpl")
@Slf4j
public class CacheRedisMessageForAllowSaleListListenerImpl
    implements MessageListener<AllowSaleListModifyNoticeDto> {

  @Autowired(required = false)
  private AllowSaleListCacheService allowSaleListCacheService;

  @Override
  public void onMessage(CharSequence channel, AllowSaleListModifyNoticeDto dto) {
    log.info("开始刷新可购清单信息...");
    this.allowSaleListCacheService.clearCache(dto);
    log.info("可购刷新结束！！！！！！");
  }
}
