package com.biz.crm.dms.business.allow.sale.local.product.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import com.biz.crm.dms.business.allow.sale.local.product.model.ProductRelateVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 允销规则关联的可购商品信息(AllowSaleRuleProduct)表数据库访问层
 *
 * @author sunx
 * @date 2021-11-19 15:17:32
 */
public interface AllowSaleRuleProductMapper extends BaseMapper<AllowSaleRuleProduct> {

  /**
   * 获取允销规则关联商品配置信息
   *
   * @param tenantCode 租户
   * @param relateType 业务类型
   * @param delFlag 删除标记
   * @param relateCodeList 业务编码
   * @return
   */
  List<ProductRelateVo> findProductRelateVoListByRelateTypeAndRelateCodes(
      @Param("tenantCode") String tenantCode,
      @Param("relateType") String relateType,
      @Param("delFlag") String delFlag,
      @Param("list") List<String> relateCodeList);
}
