package com.biz.crm.dms.business.allow.sale.local.rule.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 允销规则主细信息(AllowSaleRule)实体类
 *
 * @author sunx
 * @since 2021-11-19 15:16:24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_allow_sale_rule")
@Table(
    name = "dms_allow_sale_rule",
    indexes = {
      @Index(name = "dasr_idx1", columnList = "rule_code", unique = true),
    })
@ApiModel(value = "AllowSaleRule", description = "允销规则主细信息")
@org.hibernate.annotations.Table(appliesTo = "dms_allow_sale_rule", comment = "允销规则主细信息")
public class AllowSaleRule extends TenantFlagOpEntity {

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  @TableField(value = "rule_code")
  @Column(name = "rule_code", length = 64, columnDefinition = "varchar(64) COMMENT '允销规则编码'")
  private String ruleCode;

  /** 允销规则名称 */
  @ApiModelProperty("允销规则名称")
  @TableField(value = "rule_name")
  @Column(name = "rule_name", length = 100, columnDefinition = "varchar(100) COMMENT '允销规则名称'")
  private String ruleName;

  /**
   * 允销规则类型
   *
   * @see AllowSaleRuleTypeEnums
   */
  @ApiModelProperty("允销规则类型")
  @TableField(value = "rule_type")
  @Column(name = "rule_type", length = 36, columnDefinition = "varchar(36) COMMENT '允销规则类型'")
  private String ruleType;

  /** 规则维度 */
  @ApiModelProperty("规则维度,实现注册器AllowSaleRuleDimensionRegister,设定的type值")
  @TableField(value = "dimension_type")
  @Column(name = "dimension_type", length = 36, columnDefinition = "varchar(36) COMMENT '规则维度'")
  private String dimensionType;

  /** 创建方式 */
  @ApiModelProperty("创建方式，AllowSaleRuleCreateTypeEnums，default-默认，contract-合同")
  @TableField(value = "create_type")
  @Column(name = "create_type", length = 36, columnDefinition = "varchar(36) COMMENT '创建方式'")
  private String createType;

  /** 关联数据编码，合同编码 */
  @ApiModelProperty("关联数据编码")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 64, columnDefinition = "varchar(64) COMMENT '关联数据编码'")
  private String relateCode;

  /** 关联的组织、客户、终端明细 */
  @TableField(exist = false)
  @Transient
  @ApiModelProperty("关联的组织 客户 终端明细")
  private JSONObject dimensionJson;

  /** 关联的商品明细 */
  @TableField(exist = false)
  @Transient
  @ApiModelProperty("关联的商品明细")
  private List<AllowSaleRuleProduct> productList;

  /** 是否可编辑 */
  @TableField(exist = false)
  @Transient
  @ApiModelProperty("是否可编辑")
  private Boolean flag;
}
