package com.biz.crm.dms.business.allow.sale.local.rule.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.mapper.AllowSaleRuleMapper;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleCreateTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.rule.dto.AllowSaleRulePaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

/**
 * 允销规则主细信息(repository)
 *
 * @author sunx
 * @date 2021-11-19 15:16:25
 */
@Component
public class AllowSaleRuleRepository extends ServiceImpl<AllowSaleRuleMapper, AllowSaleRule> {

  /**
   * 分页
   *
   * @param page 分页
   * @param dto 查询参数
   * @return
   */
  public Page<AllowSaleRule> findByConditions(
      Page<AllowSaleRule> page, AllowSaleRulePaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 根据主键获取详情
   *
   * @param id 主键
   * @return
   */
  public AllowSaleRule findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据主键集合获取详情
   * @param ids 主键
   * @return
   */
  public List<AllowSaleRule> findByIds(List<String> ids) {
    return this.lambdaQuery().in(AllowSaleRule::getId, ids).list();
  }

  /**
   * 逻辑删除
   *
   * @param ids 主键
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(AllowSaleRule::getId, ids)
        .set(AllowSaleRule::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 根据规则编码获取存在的数量
   *
   * @param ruleCode 规则编码
   * @return
   */
  public Integer countByRuleCode(String ruleCode) {
    return this.lambdaQuery()
        .eq(AllowSaleRule::getTenantCode, TenantUtils.getTenantCode())
        .eq(AllowSaleRule::getRuleCode, ruleCode)
        .count();
  }

  /**
   * 根据规则编码获取详情
   *
   * @param ruleCodeList 规则编码
   * @param tenantCode 租户
   * @return
   */
  public List<AllowSaleRule> findByCodesAndTenantCode(
      List<String> ruleCodeList, String tenantCode) {
    return this.lambdaQuery()
        .eq(AllowSaleRule::getTenantCode, tenantCode)
        .in(AllowSaleRule::getRuleCode, ruleCodeList)
        .list();
  }

  /**
   * 启用 禁用
   *
   * @param ids 主键
   * @param enable 启禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(AllowSaleRule::getId, ids)
        .set(AllowSaleRule::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 根据关联业务编码+创建方式获取现有规则信息
   *
   * @param relateCodes 关联业务编码
   * @param createType 创建方式
   * @return
   */
  public List<AllowSaleRule> findByRelateCodesAndCreateType(
      List<String> relateCodes, String createType) {
    return this.lambdaQuery()
        .eq(AllowSaleRule::getTenantCode, TenantUtils.getTenantCode())
        .eq(AllowSaleRule::getCreateType, createType)
        .in(AllowSaleRule::getRelateCode, relateCodes)
        .list();
  }

  /**
   * 根据合同获取可购规则
   *
   * @param contractCodes 合同编码
   * @return
   */
  public List<AllowSaleRule> findByContractCodes(Set<String> contractCodes) {
    return this.lambdaQuery()
        .eq(AllowSaleRule::getTenantCode, TenantUtils.getTenantCode())
        .eq(AllowSaleRule::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AllowSaleRule::getCreateType, AllowSaleRuleCreateTypeEnums.CONTRACT.getCode())
        .in(AllowSaleRule::getRelateCode, contractCodes)
        .list();
  }
}
