/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.dimension.detail.service.internal;

import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.repository.AllowSaleRuleDetailRepository;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.service.AllowSaleRuleDetailService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="allowSaleRuleDetailService")
public class AllowSaleRuleDetailServiceImpl
implements AllowSaleRuleDetailService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleRuleDetailServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleDetailRepository allowSaleRuleDetailRepository;

    @Override
    @Transactional
    public List<AllowSaleRuleDetail> findByRuleCodes(List<String> ruleCodeList) {
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Lists.newLinkedList();
        }
        return this.allowSaleRuleDetailRepository.findByRuleCodes(ruleCodeList);
    }

    @Override
    @Transactional
    public void batchSave(List<AllowSaleRuleDetail> list) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String ruleCode = list.get(0).getRuleCode();
        Validate.notBlank((CharSequence)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional<AllowSaleRuleDetail> first = list.stream().filter(a -> !ruleCode.equals(a.getRuleCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5f53\u524d\u5904\u7406\u7684\u96c6\u5408\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u89c4\u5219", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        list.forEach(a -> {
            Validate.isTrue((boolean)set.add(a.getRelateCode()), (String)"\u5b58\u5728\u76f8\u540c\u7684\u7ec8\u7aef\u3001\u5ba2\u6237\u6216\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]);
            a.setTenantCode(TenantUtils.getTenantCode());
        });
        this.allowSaleRuleDetailRepository.deleteByRuleCode(ruleCode);
        this.allowSaleRuleDetailRepository.saveBatch(list);
    }

    @Override
    public List<DetailRelateVo> findByDimensionTypeAndRelateCodes(String dimensionType, List<String> relateCodeList) {
        if (StringUtils.isBlank((CharSequence)dimensionType) || CollectionUtils.isEmpty(relateCodeList)) {
            return Lists.newLinkedList();
        }
        return this.allowSaleRuleDetailRepository.findByDimensionTypeAndRelateCodes(dimensionType, relateCodeList);
    }
}

