/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.dimension.service.register;

import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.service.AllowSaleRuleDetailService;
import com.biz.crm.dms.business.allow.sale.local.util.AllowSaleUtil;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.Dimension;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.register.AllowSaleRuleDimensionRegister;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.org.OrgDimensionItemVo;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.org.OrgDimensionVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrgCustomerDimensionVoRegisterImpl
implements AllowSaleRuleDimensionRegister<OrgDimensionVo> {
    private static final Logger log = LoggerFactory.getLogger(OrgCustomerDimensionVoRegisterImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleDetailService allowSaleRuleDetailService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;

    public String getType() {
        return AllowSaleDimensionTypeEnums.CUSTOMER_ORG.getCode();
    }

    public String getTypeDesc() {
        return AllowSaleDimensionTypeEnums.CUSTOMER_ORG.getDesc();
    }

    public int sort() {
        return 2;
    }

    public Class<OrgDimensionVo> getDimensionClass() {
        return OrgDimensionVo.class;
    }

    public String getListType() {
        return AllowSaleListTypeEnums.CUSTOMER.getCode();
    }

    @Transactional
    public void saveDimensionDetail(Dimension dimension) {
        Validate.notNull((Object)dimension, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7ef4\u5ea6\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrgDimensionVo vo = (OrgDimensionVo)dimension;
        Validate.notBlank((CharSequence)vo.getRuleCode(), (String)"\u5141\u9500\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)vo.getList()), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7ef4\u5ea6\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList list = Lists.newArrayList();
        vo.getList().forEach(a -> {
            AllowSaleRuleDetail cur = new AllowSaleRuleDetail();
            cur.setRelateCode(a.getOrgCode());
            cur.setRuleCode(vo.getRuleCode());
            list.add(cur);
        });
        this.allowSaleRuleDetailService.batchSave(list);
    }

    public OrgDimensionVo findByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return null;
        }
        List<AllowSaleRuleDetail> list = this.allowSaleRuleDetailService.findByRuleCodes(Lists.newArrayList((Object[])new String[]{ruleCode}));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List codeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(AllowSaleRuleDetail::getRelateCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        List orgVoList = this.orgVoService.findByOrgCodes(codeList);
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return null;
        }
        Map<String, String> nameMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
        OrgDimensionVo vo = new OrgDimensionVo();
        ArrayList subList = Lists.newArrayList();
        list.forEach(a -> {
            OrgDimensionItemVo cur = new OrgDimensionItemVo();
            cur.setOrgCode(a.getRelateCode());
            cur.setOrgName(nameMap.getOrDefault(a.getRelateCode(), ""));
            subList.add(cur);
        });
        vo.setList((List)subList);
        return vo;
    }

    public Map<String, Set<String>> findRelateRuleCodesMapByRelateCodes(List<String> relateCodeList) {
        if (CollectionUtils.isEmpty(relateCodeList)) {
            return Maps.newHashMap();
        }
        RelateOrgCodeQueryDto relateOrgCodeQueryDto = new RelateOrgCodeQueryDto();
        relateOrgCodeQueryDto.setSearchType(Integer.valueOf(1));
        relateOrgCodeQueryDto.setOrgCodeSet((Set)Sets.newHashSet(relateCodeList));
        Map orgRuleCodeMap = this.orgVoService.findByRelateOrgCodeQueryDto(relateOrgCodeQueryDto);
        if (orgRuleCodeMap == null || orgRuleCodeMap.isEmpty()) {
            return Maps.newHashMap();
        }
        List<DetailRelateVo> list = this.allowSaleRuleDetailService.findByDimensionTypeAndRelateCodes(this.getType(), Lists.newArrayList(orgRuleCodeMap.keySet()));
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, Set<String>> map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()})).collect(Collectors.groupingBy(DetailRelateVo::getRelateCode, Collectors.mapping(DetailRelateVo::getRuleCode, Collectors.toSet())));
        return AllowSaleUtil.findRelateRule(relateCodeList, orgRuleCodeMap, map);
    }

    public Map<String, Set<String>> findRuleRelateBusinessCodesMapByRuleCodes(List<String> ruleCodeList) {
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Maps.newHashMap();
        }
        List<AllowSaleRuleDetail> list = this.allowSaleRuleDetailService.findByRuleCodes(ruleCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()})).collect(Collectors.groupingBy(AllowSaleRuleDetail::getRuleCode, Collectors.mapping(AllowSaleRuleDetail::getRelateCode, Collectors.toSet())));
        HashSet orgCodeSet = Sets.newHashSet();
        for (Set item : map.values()) {
            orgCodeSet.addAll(item);
        }
        RelateOrgCodeQueryDto relateOrgCodeQueryDto = new RelateOrgCodeQueryDto();
        relateOrgCodeQueryDto.setSearchType(Integer.valueOf(0));
        relateOrgCodeQueryDto.setOrgCodeSet((Set)orgCodeSet);
        Map orgCurRuleMap = this.orgVoService.findByRelateOrgCodeQueryDto(relateOrgCodeQueryDto);
        Map mapCusRule = this.customerVoService.findAllowSaleCustomerByOrgCodes((Set)orgCodeSet);
        if (mapCusRule == null || mapCusRule.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<String, Set<String>> orgCodeRelateRuleMap = AllowSaleUtil.findRelateBusiness(orgCurRuleMap, mapCusRule);
        if (orgCodeRelateRuleMap.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap re = Maps.newHashMap();
        for (Map.Entry item : map.entrySet()) {
            HashSet cusCodeSet = Sets.newHashSet();
            for (String orgCode : item.getValue()) {
                Set<String> curSet = orgCodeRelateRuleMap.get(orgCode);
                if (CollectionUtils.isEmpty(curSet)) continue;
                cusCodeSet.addAll(curSet);
            }
            if (CollectionUtils.isEmpty((Collection)cusCodeSet)) continue;
            re.put(item.getKey(), cusCodeSet);
        }
        return re;
    }
}

