/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.local.list.repository.AllowSaleListRepository;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListCacheService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListModifyNoticeDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListModifyNoticeItemDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AllowSaleListCacheServiceImpl
implements AllowSaleListCacheService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleListCacheServiceImpl.class);
    @Autowired(required=false)
    private Redisson redisson;
    @Autowired(required=false)
    @Qualifier(value="_allowSaleListHandlerExecutor")
    private ThreadPoolExecutor threadPoolExecutor;
    @Autowired(required=false)
    private AllowSaleListRepository allowSaleListRepository;
    private static ReentrantReadWriteLock loadLock = new ReentrantReadWriteLock();
    private static Map<String, Map<String, Set<String>>> cacheMapping = Maps.newConcurrentMap();

    @Override
    public void notifyCacheRefresh(AllowSaleListModifyNoticeDto dto) {
        Validate.notNull((Object)dto, (String)"\u5237\u65b0\u7f13\u5b58\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RTopic topic = this.redisson.getTopic("_ALLOW_SALE_LIST_NOTIFY");
        topic.publish((Object)dto);
    }

    @Override
    public void clearCache(AllowSaleListModifyNoticeDto dto) {
        Validate.notNull((Object)dto, (String)"\u5237\u65b0\u7f13\u5b58\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReentrantReadWriteLock.WriteLock writeLock = loadLock.writeLock();
        try {
            writeLock.lock();
            this.reloadCache(dto);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public Set<String> findCache(String listType, String businessCode) {
        return cacheMapping.getOrDefault(listType, Maps.newHashMap()).get(businessCode);
    }

    private void reloadCache(AllowSaleListModifyNoticeDto dto) {
        if (dto == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)dto.getList())) {
            for (AllowSaleListTypeEnums value : AllowSaleListTypeEnums.values()) {
                this.reloadCacheByListTypeAndBusinessCodes(value.getCode(), Sets.newHashSet());
            }
        } else {
            for (AllowSaleListModifyNoticeItemDto item : dto.getList()) {
                String listType = item.getListType();
                Set businessCodes = item.getBusinessCodes();
                this.reloadCacheByListTypeAndBusinessCodes(listType, businessCodes);
            }
        }
    }

    private void reloadCacheByListTypeAndBusinessCodes(String listType, Set<String> businessCodes) {
        Map<String, Set<String>> map;
        Set<String> set;
        Sets.SetView difference;
        if (StringUtils.isBlank((CharSequence)listType)) {
            return;
        }
        boolean reloadAll = CollectionUtils.isEmpty(businessCodes);
        if (CollectionUtils.isEmpty(businessCodes)) {
            businessCodes = this.allowSaleListRepository.findBusinessCodesByListTypeAndRuleType(listType, AllowSaleRuleTypeEnums.ALLOW.getDictCode());
        }
        if (CollectionUtils.isEmpty(businessCodes)) {
            if (cacheMapping.get(listType) != null) {
                cacheMapping.get(listType).clear();
            }
            return;
        }
        Lists.partition((List)Lists.newArrayList(businessCodes), (int)500).forEach(a -> CompletableFuture.runAsync(() -> this.reloadCacheItem((List<String>)a, listType), this.threadPoolExecutor));
        if (Boolean.TRUE.equals(reloadAll) && !CollectionUtils.isEmpty((Collection)(difference = Sets.difference(set = (map = cacheMapping.getOrDefault(listType, Maps.newHashMap())).keySet(), businessCodes)))) {
            for (String item : difference) {
                cacheMapping.getOrDefault(listType, Maps.newHashMap()).remove(item);
            }
        }
    }

    private void reloadCacheItem(List<String> businessCodes, String listType) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return;
        }
        List<AllowSaleList> list = this.allowSaleListRepository.findByBusinessCodesAndListTypeAndRuleType(businessCodes, listType, AllowSaleRuleTypeEnums.ALLOW.getDictCode());
        Map<Object, Object> map = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(list)) {
            map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductCode(), a.getBusinessCode()})).collect(Collectors.groupingBy(AllowSaleList::getBusinessCode, Collectors.mapping(AllowSaleList::getProductCode, Collectors.toSet())));
        }
        Map<String, Set<String>> mapItem = cacheMapping.getOrDefault(listType, Maps.newHashMap());
        for (String businessCode : businessCodes) {
            mapItem.put(businessCode, (Set)map.get(businessCode));
        }
        cacheMapping.put(listType, mapItem);
    }
}

