/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.repository.AllowSaleRuleRelateListRepository;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListProductPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListProductVoService;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListProductVo;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceItemDimensionDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.enums.ProductExtInfoTypeEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class AllowSaleListProductVoServiceImpl
implements AllowSaleListProductVoService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleListProductVoServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleListService allowSaleListService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductSpuVoService productSpuVoService;
    @Autowired(required=false)
    private AllowSaleRuleRelateListRepository allowSaleRuleRelateListRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<AllowSaleListProductVo> findByConditions(Pageable pageable, AllowSaleListProductPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        AllowSaleListPaginationDto dto1 = this.findByAllowSaleListProductPaginationDto(dto);
        if (Objects.isNull(dto1)) {
            return new Page();
        }
        Page<AllowSaleList> page = this.allowSaleListService.findByConditions(pageable, dto1);
        if (Objects.isNull(page)) {
            return new Page();
        }
        List records = page.getRecords();
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)records, AllowSaleList.class, AllowSaleListProductVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.handleRecords(list, dto);
        Page pageResult = new Page();
        pageResult.setRecords(list);
        pageResult.setCurrent((long)pageable.getPageNumber());
        pageResult.setTotal(page.getTotal());
        return pageResult;
    }

    private AllowSaleListPaginationDto findByAllowSaleListProductPaginationDto(AllowSaleListProductPaginationDto dto) {
        ProductQueryDto queryDto;
        dto = Optional.ofNullable(dto).orElse(new AllowSaleListProductPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setListType(Optional.ofNullable(dto.getListType()).orElse(AllowSaleListTypeEnums.CUSTOMER.getCode()));
        dto.setRuleType(Optional.ofNullable(dto.getRuleType()).orElse(AllowSaleRuleTypeEnums.ALLOW.getDictCode()));
        dto.setPriceFlag(Optional.ofNullable(dto.getPriceFlag()).orElse(Boolean.FALSE));
        AllowSaleListPaginationDto dto1 = (AllowSaleListPaginationDto)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, AllowSaleListPaginationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Boolean f = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getProductCode(), dto.getProductName(), dto.getProductLevelCode()});
        if (Boolean.FALSE.equals(f)) {
            queryDto = new ProductQueryDto();
            queryDto.setProductCode(dto.getProductCode());
            queryDto.setProductName(dto.getProductName());
            if (StringUtils.isNotBlank((CharSequence)dto.getProductLevelCode())) {
                queryDto.setProductLevelCodeList((List)Lists.newArrayList((Object[])new String[]{dto.getProductLevelCode()}));
            }
            queryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            queryDto.setIsShelf(IsShelfEnum.UP.getCode());
            queryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List productVos = this.productVoService.findByProductQueryDto(queryDto);
            if (CollectionUtils.isEmpty((Collection)productVos)) {
                return null;
            }
            List productCodes = productVos.stream().map(ProductVo::getProductCode).limit(500L).collect(Collectors.toList());
            dto1.setProductCodes(productCodes);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBusinessName()) || StringUtils.isNotBlank((CharSequence)dto.getBusinessCodeLike()) || StringUtils.isNotBlank((CharSequence)dto.getChannel()) || StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            Set set;
            if (dto.getListType().equals(AllowSaleListTypeEnums.CUSTOMER.getCode())) {
                queryDto = new CustomerQueryDto();
                queryDto.setCustomerName(dto.getBusinessName());
                queryDto.setChannel(dto.getChannel());
                queryDto.setOrgName(dto.getOrgName());
                queryDto.setCustomerCode(dto.getBusinessCodeLike());
                set = this.customerVoService.findByCustomerQueryDto((CustomerQueryDto)queryDto);
                if (CollectionUtils.isEmpty((Collection)set)) {
                    return null;
                }
                dto1.setBusinessCodeSet(set.stream().limit(500L).collect(Collectors.toSet()));
            } else if (dto.getListType().equals(AllowSaleListTypeEnums.TERMINAL.getCode())) {
                queryDto = new TerminalQueryDto();
                queryDto.setTerminalName(dto.getBusinessName());
                queryDto.setChannel(dto.getChannel());
                queryDto.setOrgName(dto.getOrgName());
                queryDto.setTerminalCode(dto.getBusinessCodeLike());
                set = this.terminalVoService.findByTerminalQueryDto((TerminalQueryDto)queryDto);
                if (CollectionUtils.isEmpty((Collection)set)) {
                    return null;
                }
                dto1.setBusinessCodeSet(set.stream().limit(500L).collect(Collectors.toSet()));
            }
        }
        return dto1;
    }

    private void handleRecords(List<AllowSaleListProductVo> list, AllowSaleListProductPaginationDto dto) {
        String listType = dto.getListType();
        Boolean priceFlag = dto.getPriceFlag();
        Boolean productImageFlag = dto.getProductImageFlag();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        StopWatch sw = new StopWatch();
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getBusinessCode(), a.getProductCode()})).collect(Collectors.groupingBy(AllowSaleListProductVo::getBusinessCode, Collectors.mapping(AllowSaleListProductVo::getProductCode, Collectors.toSet())));
        sw.start("1");
        Map<String, CustomerVo> mapCustomer = listType.equals(AllowSaleListTypeEnums.CUSTOMER.getCode()) ? this.findCustomerMap(map.keySet()) : null;
        Map<String, TerminalVo> mapTerminal = listType.equals(AllowSaleListTypeEnums.TERMINAL.getCode()) ? this.findTerminalMap(map.keySet()) : null;
        sw.stop();
        sw.start("2");
        Map<String, PriceModelVo> priceModelVoMap = Boolean.TRUE.equals(priceFlag) ? this.findPriceMap(list, mapCustomer, mapTerminal, listType) : null;
        sw.stop();
        sw.start("3");
        Set<String> productCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(AllowSaleListProductVo::getProductCode).collect(Collectors.toSet());
        Map<String, ProductVo> productMap = this.findProductMap(productCodeSet, productImageFlag);
        Map<String, String> productSpuCodeMap = this.findProductSpuCodeMap(productCodeSet);
        sw.stop();
        sw.start("5");
        Set<String> itemKeys = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getItemKey())).map(AllowSaleListProductVo::getItemKey).collect(Collectors.toSet());
        Map<String, String> relateRuleMap = this.findRelateRuleMap(itemKeys);
        sw.stop();
        sw.start("4");
        this.initAllowSaleListProduct(list, listType, priceFlag, mapCustomer, mapTerminal, priceModelVoMap, productMap, productSpuCodeMap, relateRuleMap);
        sw.stop();
        log.info("tj[{}]", (Object)sw.prettyPrint());
    }

    private Map<String, CustomerVo> findCustomerMap(Set<String> customerCodeSet) {
        if (CollectionUtils.isEmpty(customerCodeSet)) {
            return Maps.newHashMap();
        }
        List list = this.customerVoService.findForPriceByCustomerCodes(customerCodeSet);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (a, b) -> a));
    }

    private Map<String, TerminalVo> findTerminalMap(Set<String> terminalCodeSet) {
        if (CollectionUtils.isEmpty(terminalCodeSet)) {
            return Maps.newHashMap();
        }
        List list = this.terminalVoService.findMainDetailsByTerminalCodes((List)Lists.newArrayList(terminalCodeSet));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (a, b) -> a));
    }

    private Map<String, PriceModelVo> findPriceMap(List<AllowSaleListProductVo> list, Map<String, CustomerVo> mapCustomer, Map<String, TerminalVo> mapTerminal, String listType) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductCode(), a.getBusinessCode()})).collect(Collectors.groupingBy(AllowSaleListProductVo::getBusinessCode, Collectors.mapping(AllowSaleListProductVo::getProductCode, Collectors.toSet())));
        if (!listType.equals(AllowSaleListTypeEnums.CUSTOMER.getCode()) && !listType.equals(AllowSaleListTypeEnums.TERMINAL.getCode())) {
            return Maps.newHashMap();
        }
        FindBusinessPriceDto dto = new FindBusinessPriceDto();
        dto.setUserType(listType);
        LinkedList items = Lists.newLinkedList();
        for (Map.Entry item : map.entrySet()) {
            FindBusinessPriceItemDto cur = new FindBusinessPriceItemDto();
            cur.setBusinessCode(item.getKey());
            cur.setProductCodeSet(item.getValue());
            List<SearchPriceDimensionItemDto> dimensionItems = null;
            if (listType.equals(AllowSaleListTypeEnums.CUSTOMER.getCode())) {
                CustomerVo customerVo = mapCustomer.get(item.getKey());
                dimensionItems = this.findSearchPriceDimensionItemByCustomerVo(customerVo);
            } else if (listType.equals(AllowSaleListTypeEnums.TERMINAL.getCode())) {
                TerminalVo terminalVo = mapTerminal.get(item.getKey());
                dimensionItems = this.findSearchPriceDimensionItemByTerminalVo(terminalVo);
            }
            if (CollectionUtils.isNotEmpty(dimensionItems)) {
                LinkedList dimensions = Lists.newLinkedList();
                for (SearchPriceDimensionItemDto searchPriceDimensionItemDto : dimensionItems) {
                    FindBusinessPriceItemDimensionDto dto1 = new FindBusinessPriceItemDimensionDto();
                    dto1.setCode(searchPriceDimensionItemDto.getDimensionCode());
                    dto1.setValues(searchPriceDimensionItemDto.getRelateCodeSet());
                    dimensions.add(dto1);
                }
                cur.setDimensions((List)dimensions);
            }
            items.add(cur);
        }
        dto.setList((List)items);
        return this.priceModelVoService.findBusinessPrice(dto);
    }

    private List<SearchPriceDimensionItemDto> findSearchPriceDimensionItemByTerminalVo(TerminalVo terminalVo) {
        SearchPriceDimensionItemDto cur;
        if (Objects.isNull(terminalVo)) {
            return Lists.newLinkedList();
        }
        LinkedList dimensionItems = Lists.newLinkedList();
        if (StringUtils.isNotBlank((CharSequence)terminalVo.getTerminalCode())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.TERMINAL.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{terminalVo.getTerminalCode()}));
            dimensionItems.add(cur);
        }
        if (CollectionUtils.isNotEmpty((Collection)terminalVo.getOrgList())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.ORG.getDictCode());
            cur.setRelateCodeSet(terminalVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet()));
            dimensionItems.add(cur);
        }
        if (StringUtils.isNotBlank((CharSequence)terminalVo.getChannel())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.CHANNEL.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{terminalVo.getChannel()}));
            dimensionItems.add(cur);
        }
        return dimensionItems;
    }

    private List<SearchPriceDimensionItemDto> findSearchPriceDimensionItemByCustomerVo(CustomerVo customerVo) {
        SearchPriceDimensionItemDto cur;
        if (Objects.isNull(customerVo)) {
            return Lists.newLinkedList();
        }
        LinkedList dimensionItems = Lists.newLinkedList();
        if (StringUtils.isNotBlank((CharSequence)customerVo.getCustomerCode())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.CUSTOMER.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{customerVo.getCustomerCode()}));
            dimensionItems.add(cur);
        }
        if (CollectionUtils.isNotEmpty((Collection)customerVo.getOrgList())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.ORG.getDictCode());
            cur.setRelateCodeSet(customerVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(CustomerRelateOrgVo::getOrgCode).collect(Collectors.toSet()));
            dimensionItems.add(cur);
        }
        if (StringUtils.isNotBlank((CharSequence)customerVo.getChannel())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.CHANNEL.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{customerVo.getChannel()}));
            dimensionItems.add(cur);
        }
        if (StringUtils.isNotBlank((CharSequence)customerVo.getPriceGroup())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.PRICE_GROUP.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{customerVo.getPriceGroup()}));
            dimensionItems.add(cur);
        }
        return dimensionItems;
    }

    private Map<String, ProductVo> findProductMap(Set<String> productCodeSet, Boolean productImageFlag) {
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Maps.newHashMap();
        }
        ProductDetailQueryDto dto = new ProductDetailQueryDto();
        dto.setCodeQueryFlag(Boolean.valueOf(true));
        dto.setCodes((List)Lists.newArrayList(productCodeSet));
        HashSet set = Sets.newHashSet((Object[])new String[]{ProductExtInfoTypeEnum.PRODUCT_LEVEL.getDictCode()});
        if (Boolean.TRUE.equals(productImageFlag)) {
            set.add(ProductExtInfoTypeEnum.PICTURE.getDictCode());
        }
        dto.setExInfoCodes((Set)set);
        List list = this.productVoService.findDetailsByProductDetailQueryDto(dto);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (a, b) -> a));
    }

    private Map<String, String> findProductSpuCodeMap(Set<String> productCodeSet) {
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Maps.newHashMap();
        }
        Map map = this.productSpuVoService.findRelateSpuMapByProductCodes((List)Lists.newArrayList(productCodeSet));
        HashMap re = Maps.newHashMap();
        if (!map.isEmpty()) {
            for (Map.Entry item : map.entrySet()) {
                re.put((String)item.getKey(), ((List)item.getValue()).stream().map(ProductSpuVo::getSpuCode).collect(Collectors.joining(",")));
            }
        }
        return re;
    }

    private Map<String, String> findRelateRuleMap(Set<String> itemKeys) {
        if (CollectionUtils.isEmpty(itemKeys)) {
            return Maps.newHashMap();
        }
        List<AllowSaleRuleRelateList> list = this.allowSaleRuleRelateListRepository.findByItemKeys(itemKeys);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getItemKey(), a.getRuleCode()})).sorted(Comparator.comparing(AllowSaleRuleRelateList::getRuleType)).collect(Collectors.groupingBy(AllowSaleRuleRelateList::getItemKey, Collectors.mapping(AllowSaleRuleRelateList::getRuleCode, Collectors.joining(","))));
    }

    private void initAllowSaleListProduct(List<AllowSaleListProductVo> list, String listType, Boolean priceFlag, Map<String, CustomerVo> mapCustomer, Map<String, TerminalVo> mapTerminal, Map<String, PriceModelVo> priceModelVoMap, Map<String, ProductVo> productMap, Map<String, String> productSpuCodeMap, Map<String, String> relateRuleMap) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (AllowSaleListProductVo item : list) {
            PriceModelVo priceModelVo;
            ProductVo productVo;
            TerminalVo terminalVo;
            CustomerVo customerVo;
            item.setListType(listType);
            item.setRelateRuleCode(relateRuleMap.getOrDefault(item.getItemKey(), ""));
            if (listType.equals(AllowSaleListTypeEnums.CUSTOMER.getCode()) && Objects.nonNull(customerVo = mapCustomer.get(item.getBusinessCode()))) {
                item.setBusinessName(customerVo.getCustomerName());
                if (CollectionUtils.isNotEmpty((Collection)customerVo.getOrgList())) {
                    item.setOrgCode(customerVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(CustomerRelateOrgVo::getOrgCode).collect(Collectors.joining(",")));
                    item.setOrgName(customerVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgName())).map(CustomerRelateOrgVo::getOrgName).collect(Collectors.joining(",")));
                }
                item.setChannel(customerVo.getChannel());
                item.setPriceGroup(customerVo.getPriceGroup());
            }
            if (listType.equals(AllowSaleListTypeEnums.TERMINAL.getCode()) && Objects.nonNull(terminalVo = mapTerminal.get(item.getBusinessCode()))) {
                item.setBusinessName(terminalVo.getTerminalName());
                if (CollectionUtils.isNotEmpty((Collection)terminalVo.getOrgList())) {
                    item.setOrgCode(terminalVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.joining(",")));
                    item.setOrgName(terminalVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgName())).map(TerminalRelaOrgVo::getOrgName).collect(Collectors.joining(",")));
                }
                item.setChannel(terminalVo.getChannel());
            }
            if (Objects.nonNull(productVo = productMap.get(item.getProductCode()))) {
                item.setProductLevelCode(productVo.getProductLevelCode());
                item.setProductLevelName(productVo.getProductLevelName());
                item.setProductName(productVo.getProductName());
                item.setSpec(productVo.getSpec());
                item.setSaleUnit(productVo.getSaleUnit());
            }
            item.setProduct(productVo);
            item.setSpuCode(productSpuCodeMap.get(item.getProductCode()));
            if (!Boolean.TRUE.equals(priceFlag) || !Objects.nonNull(priceModelVo = priceModelVoMap.get(item.getPriceKey()))) continue;
            item.setPrice(priceModelVo.getPrice());
            item.setPriceCode(priceModelVo.getPriceCode());
        }
    }
}

