/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.service.AllowSaleRuleService;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.customer.CustomerDimensionItemVo;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.customer.CustomerDimensionVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleElementEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleCreateTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleProductRelateTypeEnums;
import com.biz.crm.dms.business.contract.sdk.enums.ContractCancellationState;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.dms.business.contract.sdk.event.contract.ContractEventListener;
import com.biz.crm.dms.business.contract.sdk.event.contractsign.ContractSignEventListener;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AllowContractSignEventListenerImpl
implements ContractSignEventListener,
ContractEventListener {
    private static final Logger log = LoggerFactory.getLogger(AllowContractSignEventListenerImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleService allowSaleRuleService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    private static final String CONTRACT_ELEMENT_CODE = "allowSaleElementRegister";

    @Transactional
    public void onSignContract(ContractVo vo) {
        if (Objects.isNull(vo) || StringUtils.isBlank((CharSequence)vo.getContractCode()) || Objects.isNull(vo.getElementDataMap())) {
            return;
        }
        String contractCode = vo.getContractCode();
        String contractName = vo.getContractName();
        String cusCode = vo.getCusCode();
        String effectiveStatus = vo.getEffectiveStatus();
        String enableStatus = EffectiveStatusEnum.EFFECTIVE_ACTIVE.getDictCode().equals(effectiveStatus) ? EnableStatusEnum.ENABLE.getCode() : EnableStatusEnum.DISABLE.getCode();
        Map<String, List<AllowSaleElementVo>> map = this.findAllowSaleElementMap(vo);
        if (map == null || map.isEmpty()) {
            return;
        }
        List<AllowSaleElementVo> productList = map.get(AllowSaleElementEnums.PRODUCT.getCode());
        List<AllowSaleElementVo> productLevelList = map.get(AllowSaleElementEnums.PRODUCT_LEVEL.getCode());
        Set<Object> productCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(productList)) {
            productCodeSet = productList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(AllowSaleElementVo::getProductCode).collect(Collectors.toSet());
        }
        Set<Object> productLevelCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(productLevelList)) {
            productLevelCodeSet = productLevelList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductLevelCode())).map(AllowSaleElementVo::getProductLevelCode).collect(Collectors.toSet());
        }
        this.createRule(contractCode, contractName, cusCode, enableStatus, productCodeSet, productLevelCodeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void onCancellation(ContractVo vo) {
        if (Objects.isNull(vo)) {
            return;
        }
        String contractCode = vo.getContractCode();
        if (StringUtils.isBlank((CharSequence)contractCode)) {
            return;
        }
        String enableStatus = EnableStatusEnum.DISABLE.getCode();
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            this.allowSaleRuleService.updateByContractCodesAndEnableStatus(Lists.newArrayList((Object[])new String[]{contractCode}), enableStatus);
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    @Transactional
    public void onEnable(List<ContractVo> list) {
        this.enableAndDisableRule(list, EnableStatusEnum.ENABLE.getCode());
    }

    @Transactional
    public void onDisable(List<ContractVo> list) {
        this.enableAndDisableRule(list, EnableStatusEnum.DISABLE.getCode());
    }

    @Transactional
    public void onMaturity(List<ContractVo> list) {
        this.enableAndDisableRule(list, EnableStatusEnum.DISABLE.getCode());
    }

    @Transactional
    public void onEffective(List<ContractVo> list) {
        this.enableAndDisableRule(list, EnableStatusEnum.ENABLE.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRule(String contractCode, String contractName, String cusCode, String enableStatus, Set<String> productCodeSet, Set<String> productLevelCodeSet) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            AllowSaleRuleProduct cur;
            AllowSaleRule allowSaleRule = new AllowSaleRule();
            allowSaleRule.setRuleName("\u5408\u540c-" + contractName);
            allowSaleRule.setDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER.getCode());
            allowSaleRule.setCreateType(AllowSaleRuleCreateTypeEnums.CONTRACT.getCode());
            allowSaleRule.setRelateCode(contractCode);
            CustomerDimensionVo customerDimensionVo = new CustomerDimensionVo();
            CustomerDimensionItemVo customerDimensionItemVo = new CustomerDimensionItemVo();
            customerDimensionItemVo.setCustomerCode(cusCode);
            customerDimensionVo.setList((List)Lists.newArrayList((Object[])new CustomerDimensionItemVo[]{customerDimensionItemVo}));
            allowSaleRule.setDimensionJson((JSONObject)JSON.toJSON((Object)customerDimensionVo));
            enableStatus = Optional.ofNullable(enableStatus).orElse(EnableStatusEnum.DISABLE.getCode());
            allowSaleRule.setEnableStatus(enableStatus);
            ArrayList productList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(productCodeSet)) {
                for (String item : productCodeSet) {
                    cur = new AllowSaleRuleProduct();
                    cur.setRelateCode(item);
                    cur.setRelateType(AllowSaleRuleProductRelateTypeEnums.PRODUCT.getCode());
                    productList.add(cur);
                }
            }
            if (!CollectionUtils.isEmpty(productLevelCodeSet)) {
                for (String item : productLevelCodeSet) {
                    cur = new AllowSaleRuleProduct();
                    cur.setRelateCode(item);
                    cur.setRelateType(AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode());
                    productList.add(cur);
                }
            }
            allowSaleRule.setProductList(productList);
            if (CollectionUtils.isEmpty(allowSaleRule.getProductList())) {
                log.error("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u521b\u5efa\u89c4\u5219");
                return;
            }
            this.allowSaleRuleService.create(allowSaleRule);
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableAndDisableRule(List<ContractVo> list, String enableStatus) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            String newEnableStatus;
            String string = newEnableStatus = EnableStatusEnum.ENABLE.getCode().equals(enableStatus) ? EnableStatusEnum.DISABLE.getCode() : EnableStatusEnum.ENABLE.getCode();
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            Set<String> contractCodes = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getContractCode()) && EffectiveStatusEnum.EFFECTIVE_ACTIVE.getKey().equals(a.getEffectiveStatus()) && ContractCancellationState.CANCELLATION.getKey().equals(a.getCancellationState())).map(ContractVo::getContractCode).collect(Collectors.toSet());
            if (EnableStatusEnum.DISABLE.getCode().equals(enableStatus)) {
                contractCodes = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getContractCode())).map(ContractVo::getContractCode).collect(Collectors.toSet());
            }
            if (CollectionUtils.isEmpty(contractCodes)) {
                return;
            }
            List<AllowSaleRule> ruleList = this.allowSaleRuleService.findByContractCodes(contractCodes);
            if (!CollectionUtils.isEmpty(ruleList)) {
                Set ids = ruleList.stream().filter(a -> newEnableStatus.equals(a.getEnableStatus())).map(UuidEntity::getId).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(ids)) {
                    return;
                }
                if (EnableStatusEnum.ENABLE.getCode().equals(enableStatus)) {
                    this.allowSaleRuleService.updateByContractCodesAndEnableStatus(Lists.newArrayList(ids), enableStatus);
                } else {
                    this.allowSaleRuleService.updateByContractCodesAndEnableStatus(Lists.newArrayList(ids), enableStatus);
                }
            }
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    private Map<String, List<AllowSaleElementVo>> findAllowSaleElementMap(ContractVo vo) {
        if (Objects.isNull(vo) || StringUtils.isBlank((CharSequence)vo.getContractCode()) || Objects.isNull(vo.getElementDataMap())) {
            return Maps.newHashMap();
        }
        JSONObject jsonObject = (JSONObject)vo.getElementDataMap().get(CONTRACT_ELEMENT_CODE);
        if (Objects.isNull(jsonObject)) {
            return Maps.newHashMap();
        }
        AllowSaleElementDataVo allowSaleElementDataVo = (AllowSaleElementDataVo)JSON.parseObject((String)jsonObject.toJSONString(), AllowSaleElementDataVo.class);
        if (Objects.isNull(allowSaleElementDataVo) || Objects.isNull(allowSaleElementDataVo.getAllowSaleMap()) || allowSaleElementDataVo.getAllowSaleMap().isEmpty()) {
            return Maps.newHashMap();
        }
        return allowSaleElementDataVo.getAllowSaleMap();
    }
}

