/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleRuleRelateListService;
import com.biz.crm.dms.business.allow.sale.local.product.service.AllowSaleRuleProductService;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.service.AllowSaleRuleService;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelEventDto;
import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AllowProductLevelEventListenerImpl
implements ProductLevelEventListener {
    @Autowired(required=false)
    private DimensionService dimensionService;
    @Autowired(required=false)
    private AllowSaleRuleProductService allowSaleRuleProductService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private AllowSaleRuleService allowSaleRuleService;
    @Autowired(required=false)
    private AllowSaleRuleRelateListService allowSaleRuleRelateListService;

    public void onBatchCreate(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchUpdate(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchDelete(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchEnable(List<ProductLevelVo> productLevelVos) {
    }

    public void onBatchDisable(List<ProductLevelVo> eventDtos) {
    }

    @Transactional
    public void onUpdate(ProductLevelEventDto dto) {
        Map<String, Set<String>> map;
        if (Objects.isNull(dto) || dto.getParentCode().equals(dto.getOldParentCode()) || StringUtils.isBlank((CharSequence)dto.getProductLevelCode())) {
            return;
        }
        Set<Object> oldAllowRuleCodes = Sets.newHashSet();
        Set<Object> allowRuleCodes = Sets.newHashSet();
        if (!StringUtils.isBlank((CharSequence)dto.getOldParentCode())) {
            map = this.allowSaleRuleProductService.findProductLevelRelateRuleCodesMapByProductLevelCodes(Lists.newArrayList((Object[])new String[]{dto.getOldParentCode()}));
            oldAllowRuleCodes = map.getOrDefault(dto.getOldParentCode(), Sets.newHashSet());
        }
        if (!StringUtils.isBlank((CharSequence)dto.getParentCode())) {
            map = this.allowSaleRuleProductService.findProductLevelRelateRuleCodesMapByProductLevelCodes(Lists.newArrayList((Object[])new String[]{dto.getParentCode()}));
            allowRuleCodes = map.getOrDefault(dto.getParentCode(), Sets.newHashSet());
        }
        if (CollectionUtils.isEmpty((Collection)oldAllowRuleCodes) && CollectionUtils.isEmpty((Collection)allowRuleCodes)) {
            return;
        }
        HashSet delRuleCodeSet = Sets.newHashSet((Iterable)Sets.difference((Set)oldAllowRuleCodes, (Set)allowRuleCodes));
        HashSet addRuleCodeSet = Sets.newHashSet((Iterable)Sets.difference((Set)allowRuleCodes, (Set)oldAllowRuleCodes));
        HashSet allRuleCodeSet = Sets.newHashSet();
        allRuleCodeSet.addAll(addRuleCodeSet);
        allRuleCodeSet.addAll(delRuleCodeSet);
        if (CollectionUtils.isEmpty((Collection)allRuleCodeSet)) {
            return;
        }
        List<AllowSaleRule> ruleList = this.allowSaleRuleService.findByCodesAndTenantCode(Lists.newArrayList((Iterable)allRuleCodeSet), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        Map<String, AllowSaleRule> mapRule = ruleList.stream().filter(a -> DelFlagStatusEnum.NORMAL.getCode().equals(a.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(a.getEnableStatus())).collect(Collectors.toMap(AllowSaleRule::getRuleCode, Function.identity(), (a, b) -> a));
        Map map2 = this.productVoService.findAllowSaleProductByProductLevelCodes((Set)Sets.newHashSet((Object[])new String[]{dto.getProductLevelCode()}));
        if (map2.isEmpty()) {
            return;
        }
        Set<String> productCodeSet = map2.keySet();
        this.handlerAllowSaleList(delRuleCodeSet, addRuleCodeSet, mapRule, productCodeSet);
    }

    private void handlerAllowSaleList(Set<String> delRuleCodeSet, Set<String> addRuleCodeSet, Map<String, AllowSaleRule> mapRule, Set<String> productCodeSet) {
        if (mapRule.isEmpty() || CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        for (Map.Entry<String, AllowSaleRule> item : mapRule.entrySet()) {
            String ruleCode = item.getKey();
            AllowSaleRule rule = item.getValue();
            List<AllowSaleRuleRelateList> list = this.findItemRelateList(rule, productCodeSet, tenantCode);
            if (CollectionUtils.isEmpty(list)) continue;
            if (delRuleCodeSet.contains(ruleCode)) {
                this.allowSaleRuleRelateListService.deleteByList(list);
                continue;
            }
            if (!addRuleCodeSet.contains(ruleCode)) continue;
            this.allowSaleRuleRelateListService.createByList(list);
        }
    }

    private List<AllowSaleRuleRelateList> findItemRelateList(AllowSaleRule rule, Set<String> productCodeSet, String tenantCode) {
        Map<String, Set<String>> businessCodeMap = this.dimensionService.findRuleRelateBusinessCodesMapByRuleCodes(Lists.newArrayList((Object[])new String[]{rule.getRuleCode()}), rule.getDimensionType());
        if (businessCodeMap.isEmpty()) {
            return Lists.newLinkedList();
        }
        Set<String> businessCodeSet = businessCodeMap.getOrDefault(rule.getRuleCode(), Sets.newHashSet());
        String listType = this.dimensionService.getListType(rule.getDimensionType());
        ArrayList list = Lists.newArrayList();
        for (String businessCode : businessCodeSet) {
            for (String productCode : productCodeSet) {
                AllowSaleRuleRelateList cur = new AllowSaleRuleRelateList();
                cur.setTenantCode(tenantCode);
                cur.setRuleType(rule.getRuleType());
                cur.setRuleCode(rule.getRuleCode());
                cur.setBusinessCode(businessCode);
                cur.setProductCode(productCode);
                cur.setListType(listType);
                cur.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                cur.setSubItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getRuleCode(), cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                RelateRule relateRule = new RelateRule();
                relateRule.setRuleType(cur.getRuleType());
                relateRule.setRuleCode(cur.getRuleCode());
                relateRule.setListType(cur.getListType());
                cur.setRule(relateRule);
                list.add(cur);
            }
        }
        return list;
    }
}

