/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleBusinessTrigger;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalEventDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AllowTerminalEventListenerImpl
implements TerminalEventListener {
    @Autowired(required=false)
    private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

    @Transactional
    public void onApproved(TerminalEventDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalVo vo = dto.getNewest();
        Validate.notNull((Object)vo, (String)"\u7ec8\u7aef\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        vo.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
        String terminalCode = vo.getTerminalCode();
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return;
        }
        this.handlerAllowSale(vo, Boolean.TRUE);
    }

    @Transactional
    public void onUpdate(TerminalEventDto dto) {
        TerminalRelaOrgVo cur;
        LinkedList curOrgList;
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalVo oldVo = dto.getOriginal();
        TerminalVo vo = dto.getNewest();
        Validate.notNull((Object)vo, (String)"\u7ec8\u7aef\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List oldOrgList = oldVo.getOrgList();
        List orgList = vo.getOrgList();
        Set<Object> oldOrgCodeSet = Sets.newHashSet();
        Set<Object> orgCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)oldOrgList)) {
            oldOrgCodeSet = oldOrgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            orgCodeSet = orgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet());
        }
        Sets.SetView d1 = Sets.difference((Set)oldOrgCodeSet, (Set)orgCodeSet);
        Sets.SetView d2 = Sets.difference((Set)orgCodeSet, (Set)oldOrgCodeSet);
        if (!ActApproveStatusEnum.APPROVED.getCode().equals(vo.getProcessStatus()) || d1.isEmpty() && d2.isEmpty()) {
            return;
        }
        if (!d1.isEmpty()) {
            curOrgList = Lists.newLinkedList();
            for (String item : d1) {
                cur = new TerminalRelaOrgVo();
                cur.setOrgCode(item);
                curOrgList.add(cur);
            }
            oldVo.setOrgList((List)curOrgList);
            this.handlerAllowSale(oldVo, Boolean.FALSE);
        }
        if (!d2.isEmpty()) {
            curOrgList = Lists.newLinkedList();
            for (String item : d2) {
                cur = new TerminalRelaOrgVo();
                cur.setOrgCode(item);
                curOrgList.add(cur);
            }
            vo.setOrgList((List)curOrgList);
            this.handlerAllowSale(vo, Boolean.TRUE);
        }
    }

    @Transactional
    public void onDelete(TerminalEventDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u5ba1\u6838\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalVo original = dto.getOriginal();
        Validate.notNull((Object)original, (String)"\u7ec8\u7aef\u5ba1\u6838\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!ActApproveStatusEnum.APPROVED.getCode().equals(original.getProcessStatus())) {
            return;
        }
        this.handlerAllowSale(original, Boolean.FALSE);
    }

    private void handlerAllowSale(TerminalVo vo, Boolean createFlag) {
        if (Objects.isNull(vo) || StringUtils.isBlank((CharSequence)vo.getTerminalCode())) {
            return;
        }
        String terminalCode = vo.getTerminalCode();
        List orgList = vo.getOrgList();
        Set<Object> orgCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            orgCodeSet = orgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty((Collection)orgCodeSet)) {
            AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
            business.setBusinessCode(terminalCode);
            business.setDimensionType(AllowSaleDimensionTypeEnums.TERMINAL.getCode());
            if (Boolean.TRUE.equals(createFlag)) {
                this.allowSaleRuleListAdapter.createByBusiness(business);
            } else {
                this.allowSaleRuleListAdapter.deleteByBusiness(business);
            }
        } else {
            for (String orgCode : orgCodeSet) {
                AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
                business.setBusinessCode(terminalCode);
                business.setDimensionType(AllowSaleDimensionTypeEnums.TERMINAL.getCode());
                business.setRelateTypeCode(orgCode);
                business.setRelateDimensionType(AllowSaleDimensionTypeEnums.TERMINAL_ORG.getCode());
                if (Boolean.TRUE.equals(createFlag)) {
                    this.allowSaleRuleListAdapter.createByBusiness(business);
                    continue;
                }
                this.allowSaleRuleListAdapter.deleteByBusiness(business);
            }
        }
    }
}

