/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.product.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import com.biz.crm.dms.business.allow.sale.local.product.model.ProductRelateVo;
import com.biz.crm.dms.business.allow.sale.local.product.repository.AllowSaleRuleProductRepository;
import com.biz.crm.dms.business.allow.sale.local.product.service.AllowSaleRuleProductService;
import com.biz.crm.dms.business.allow.sale.local.util.AllowSaleUtil;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleProductRelateTypeEnums;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AllowSaleRuleProductServiceImpl
implements AllowSaleRuleProductService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleRuleProductServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleProductRepository allowSaleRuleProductRepository;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductSpuVoService productSpuVoService;
    @Autowired(required=false)
    private ProductSpuRelateSkuVoService productSpuRelateSkuVoService;

    @Override
    @Transactional
    public List<AllowSaleRuleProduct> findByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return Lists.newLinkedList();
        }
        List<AllowSaleRuleProduct> list = this.allowSaleRuleProductRepository.findByRuleCodes(Lists.newArrayList((Object[])new String[]{ruleCode}));
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        Map<String, Set<String>> map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRelateType()})).collect(Collectors.groupingBy(AllowSaleRuleProduct::getRelateType, Collectors.mapping(AllowSaleRuleProduct::getRelateCode, Collectors.toSet())));
        if (Objects.isNull(map) || map.isEmpty()) {
            return list;
        }
        Map<String, String> mapProduct = this.findProductNameMap(map);
        Map<String, String> mapSpu = this.findSpuNameMap(map);
        Map<String, String> mapProductLevel = this.findProductLevelNameMap(map);
        for (AllowSaleRuleProduct item : list) {
            if (AllowSaleRuleProductRelateTypeEnums.PRODUCT.getCode().equals(item.getRelateType())) {
                item.setRelateName(mapProduct.get(item.getRelateCode()));
            }
            if (AllowSaleRuleProductRelateTypeEnums.SPU.getCode().equals(item.getRelateType())) {
                item.setRelateName(mapSpu.get(item.getRelateCode()));
            }
            if (!AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode().equals(item.getRelateType())) continue;
            item.setRelateName(mapProductLevel.get(item.getRelateCode()));
        }
        return list;
    }

    @Override
    @Transactional
    public void batchSave(List<AllowSaleRuleProduct> list) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String ruleCode = list.get(0).getRuleCode();
        Validate.notBlank((CharSequence)ruleCode, (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional<AllowSaleRuleProduct> first = list.stream().filter(a -> !ruleCode.equals(a.getRuleCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5f53\u524d\u5904\u7406\u7684\u96c6\u5408\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u89c4\u5219", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        list.forEach(a -> Validate.isTrue((boolean)set.add(a.getItemCode()), (String)"\u5b58\u5728\u76f8\u540c\u53ef\u8d2d\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]));
        this.allowSaleRuleProductRepository.deleteByRuleCode(ruleCode);
        this.allowSaleRuleProductRepository.saveBatch(list);
    }

    @Override
    public Map<String, Set<String>> findRuleRelateProductCodesMapByRuleCodes(List<String> ruleCodeList) {
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Maps.newHashMap();
        }
        List<AllowSaleRuleProduct> list = this.allowSaleRuleProductRepository.findByRuleCodes(ruleCodeList);
        Map<String, Set<String>> map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRelateType()})).collect(Collectors.groupingBy(AllowSaleRuleProduct::getRelateType, Collectors.mapping(AllowSaleRuleProduct::getRelateCode, Collectors.toSet())));
        if (Objects.isNull(map) || map.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap spuRelateProductCodeMap = Maps.newHashMap();
        Map<String, Set<String>> levelRelateProductCodeMap = this.findLevelRelateProductCodeMap(map);
        Set<String> productCodeSet = this.findProductRelateMap(map);
        HashSet allProductCodeSet = Sets.newHashSet();
        if (!spuRelateProductCodeMap.isEmpty()) {
            spuRelateProductCodeMap.values().forEach(allProductCodeSet::addAll);
        }
        if (!levelRelateProductCodeMap.isEmpty()) {
            levelRelateProductCodeMap.values().forEach(allProductCodeSet::addAll);
        }
        if (!productCodeSet.isEmpty()) {
            allProductCodeSet.addAll(productCodeSet);
        }
        if (CollectionUtils.isEmpty((Collection)allProductCodeSet)) {
            return Maps.newHashMap();
        }
        ProductQueryDto queryDto = new ProductQueryDto();
        queryDto.setIsShelf(IsShelfEnum.UP.getCode());
        queryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        queryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        queryDto.setProductCodeList((List)Lists.newArrayList((Iterable)allProductCodeSet));
        List normalProductVoList = this.productVoService.findByProductQueryDto(queryDto);
        if (CollectionUtils.isEmpty((Collection)normalProductVoList)) {
            return Maps.newHashMap();
        }
        Set normalProductCodeSet = normalProductVoList.stream().map(ProductVo::getProductCode).collect(Collectors.toSet());
        Map<String, List<AllowSaleRuleProduct>> ruleProductMap = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRuleCode(), a.getRelateType(), a.getRelateCode()})).collect(Collectors.groupingBy(AllowSaleRuleProduct::getRuleCode));
        if (Objects.isNull(ruleProductMap) || ruleProductMap.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap reMap = Maps.newHashMap();
        for (Map.Entry<String, List<AllowSaleRuleProduct>> item : ruleProductMap.entrySet()) {
            HashSet curProductCodeSet = Sets.newHashSet();
            item.getValue().forEach(a -> {
                Set cur;
                Sets.SetView view;
                if (AllowSaleRuleProductRelateTypeEnums.PRODUCT.getCode().equals(a.getRelateType())) {
                    if (normalProductCodeSet.contains(a.getRelateCode())) {
                        curProductCodeSet.add(a.getRelateCode());
                    }
                } else if (AllowSaleRuleProductRelateTypeEnums.SPU.getCode().equals(a.getRelateType())) {
                    Set cur2 = (Set)spuRelateProductCodeMap.get(a.getRelateCode());
                    Sets.SetView view2 = Sets.intersection((Set)cur2, (Set)normalProductCodeSet);
                    if (CollectionUtils.isNotEmpty((Collection)view2)) {
                        curProductCodeSet.addAll(view2);
                    }
                } else if (AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode().equals(a.getRelateType()) && CollectionUtils.isNotEmpty((Collection)(view = Sets.intersection((Set)(cur = (Set)levelRelateProductCodeMap.getOrDefault(a.getRelateCode(), Sets.newHashSet())), (Set)normalProductCodeSet)))) {
                    curProductCodeSet.addAll(cur);
                }
            });
            if (!CollectionUtils.isNotEmpty((Collection)curProductCodeSet)) continue;
            reMap.put(item.getKey(), curProductCodeSet);
        }
        return reMap;
    }

    @Override
    public Map<String, Set<String>> findProductLevelRelateRuleCodesMapByProductLevelCodes(List<String> productLevelCodeList) {
        if (CollectionUtils.isEmpty(productLevelCodeList)) {
            return Maps.newHashMap();
        }
        RelateProductLevelCodeQueryDto relateProductLevelCodeQueryDto = new RelateProductLevelCodeQueryDto();
        relateProductLevelCodeQueryDto.setSearchType(Integer.valueOf(1));
        relateProductLevelCodeQueryDto.setProductLevelCodeSet((Set)Sets.newHashSet(productLevelCodeList));
        Map productLevelRuleCodeMap = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(relateProductLevelCodeQueryDto);
        if (productLevelRuleCodeMap.isEmpty()) {
            return Maps.newHashMap();
        }
        List<ProductRelateVo> list = this.allowSaleRuleProductRepository.findProductRelateVoListByRelateTypeAndRelateCodes(AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode(), Lists.newArrayList(productLevelRuleCodeMap.keySet()));
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, Set<String>> map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()})).collect(Collectors.groupingBy(ProductRelateVo::getRelateCode, Collectors.mapping(ProductRelateVo::getRuleCode, Collectors.toSet())));
        return AllowSaleUtil.findRelateRule(productLevelCodeList, productLevelRuleCodeMap, map);
    }

    @Override
    public Map<String, Set<String>> findSpuRelateRuleCodesMapBySpuCodes(List<String> spuCodeList) {
        if (CollectionUtils.isEmpty(spuCodeList)) {
            return Maps.newHashMap();
        }
        List<ProductRelateVo> list = this.allowSaleRuleProductRepository.findProductRelateVoListByRelateTypeAndRelateCodes(AllowSaleRuleProductRelateTypeEnums.SPU.getCode(), spuCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()})).collect(Collectors.groupingBy(ProductRelateVo::getRelateCode, Collectors.mapping(ProductRelateVo::getRuleCode, Collectors.toSet())));
    }

    @Override
    public Map<String, Set<String>> findSkuRelateRuleCodesMapBySkuCodes(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Maps.newHashMap();
        }
        List<ProductRelateVo> list = this.allowSaleRuleProductRepository.findProductRelateVoListByRelateTypeAndRelateCodes(AllowSaleRuleProductRelateTypeEnums.PRODUCT.getCode(), productCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()})).collect(Collectors.groupingBy(ProductRelateVo::getRelateCode, Collectors.mapping(ProductRelateVo::getRuleCode, Collectors.toSet())));
    }

    private Map<String, String> findProductLevelNameMap(Map<String, Set<String>> map) {
        Set<String> productLevelCodeSet = map.get(AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode());
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return Maps.newHashMap();
        }
        List list = this.productLevelVoSdkService.findListByCodes((List)Lists.newArrayList(productLevelCodeSet));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getProductLevelName()})).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
    }

    private Map<String, String> findSpuNameMap(Map<String, Set<String>> map) {
        Set<String> spuCodeSet = map.get(AllowSaleRuleProductRelateTypeEnums.SPU.getCode());
        if (CollectionUtils.isEmpty(spuCodeSet)) {
            return Maps.newHashMap();
        }
        List list = this.productSpuVoService.findBySpuCodes((List)Lists.newArrayList(spuCodeSet));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSpuCode(), a.getSpuName()})).collect(Collectors.toMap(ProductSpuVo::getSpuCode, ProductSpuVo::getSpuName, (a, b) -> a));
    }

    private Map<String, String> findProductNameMap(Map<String, Set<String>> map) {
        Set<String> productCodeSet = map.get(AllowSaleRuleProductRelateTypeEnums.PRODUCT.getCode());
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Maps.newHashMap();
        }
        List list = this.productVoService.findDetailsByIdsOrProductCodes((List)Lists.newLinkedList(), (List)Lists.newArrayList(productCodeSet));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductCode(), a.getProductName()})).collect(Collectors.toMap(ProductVo::getProductCode, ProductVo::getProductName, (a, b) -> a));
    }

    private Map<String, Set<String>> findLevelRelateProductCodeMap(Map<String, Set<String>> map) {
        Set<String> productLevelCodeSet = map.get(AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode());
        if (CollectionUtils.isEmpty(productLevelCodeSet)) {
            return Maps.newHashMap();
        }
        RelateProductLevelCodeQueryDto relateProductLevelCodeQueryDto = new RelateProductLevelCodeQueryDto();
        relateProductLevelCodeQueryDto.setSearchType(Integer.valueOf(-1));
        relateProductLevelCodeQueryDto.setProductLevelCodeSet(productLevelCodeSet);
        Map map1 = this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(relateProductLevelCodeQueryDto);
        if (map1.isEmpty()) {
            return Maps.newHashMap();
        }
        ProductQueryDto productQueryDto = new ProductQueryDto();
        productQueryDto.setProductLevelCodeList((List)Lists.newArrayList(map1.keySet()));
        productQueryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productQueryDto.setIsShelf(IsShelfEnum.UP.getCode());
        productQueryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List list = this.productVoService.findByProductQueryDto(productQueryDto);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        for (ProductVo item : list) {
            String ruleCode = (String)map1.get(item.getProductLevelCode());
            if (StringUtils.isBlank((CharSequence)ruleCode)) continue;
            item.setProductLevelCode(ruleCode);
        }
        Map mapLevelProduct = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getProductCode()})).collect(Collectors.groupingBy(ProductVo::getProductLevelCode, Collectors.mapping(ProductVo::getProductCode, Collectors.toSet())));
        HashMap re = Maps.newHashMap();
        for (String item : productLevelCodeSet) {
            String ruleCode = (String)map1.get(item);
            if (StringUtils.isBlank((CharSequence)ruleCode)) continue;
            HashSet set = Sets.newHashSet();
            for (Map.Entry sub : mapLevelProduct.entrySet()) {
                if (!sub.getKey().startsWith(ruleCode)) continue;
                set.addAll(sub.getValue());
            }
            if (!CollectionUtils.isNotEmpty((Collection)set)) continue;
            re.put(item, set);
        }
        return re;
    }

    private Set<String> findProductRelateMap(Map<String, Set<String>> map) {
        Set<String> productCodeSet = map.get(AllowSaleRuleProductRelateTypeEnums.PRODUCT.getCode());
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return Sets.newHashSet();
        }
        ProductQueryDto productQueryDto = new ProductQueryDto();
        productQueryDto.setProductCodeList((List)Lists.newArrayList(productCodeSet));
        productQueryDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        productQueryDto.setIsShelf(IsShelfEnum.UP.getCode());
        productQueryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List list = this.productVoService.findByProductQueryDto(productQueryDto);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Sets.newHashSet();
        }
        return list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode())).map(ProductVo::getProductCode).collect(Collectors.toSet());
    }

    private Map<String, Set<String>> findSpuRelateProductCodeMap(Map<String, Set<String>> map) {
        Set<String> spuCodeSet = map.get(AllowSaleRuleProductRelateTypeEnums.SPU.getCode());
        if (CollectionUtils.isEmpty(spuCodeSet)) {
            return Maps.newHashMap();
        }
        List list = this.productSpuRelateSkuVoService.findBySpuCodes((List)Lists.newArrayList(spuCodeSet));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSpuCode(), a.getProductCode()})).collect(Collectors.groupingBy(ProductSpuRelateSkuVo::getSpuCode, Collectors.mapping(ProductSpuRelateSkuVo::getProductCode, Collectors.toSet())));
    }
}

