/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.rule.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.mapper.AllowSaleRuleMapper;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleCreateTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.rule.dto.AllowSaleRulePaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class AllowSaleRuleRepository
extends ServiceImpl<AllowSaleRuleMapper, AllowSaleRule> {
    public Page<AllowSaleRule> findByConditions(Page<AllowSaleRule> page, AllowSaleRulePaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((AllowSaleRuleMapper)this.baseMapper).findByConditions(page, dto);
    }

    public AllowSaleRule findById(String id) {
        return (AllowSaleRule)((Object)((AllowSaleRuleMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<AllowSaleRule> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Integer countByRuleCode(String ruleCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AllowSaleRule::getRuleCode, (Object)ruleCode)).count();
    }

    public List<AllowSaleRule> findByCodesAndTenantCode(List<String> ruleCodeList, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(AllowSaleRule::getRuleCode, ruleCodeList)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public List<AllowSaleRule> findByRelateCodesAndCreateType(List<String> relateCodes, String createType) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AllowSaleRule::getCreateType, (Object)createType)).in(AllowSaleRule::getRelateCode, relateCodes)).list();
    }

    public List<AllowSaleRule> findByContractCodes(Set<String> contractCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(AllowSaleRule::getCreateType, (Object)AllowSaleRuleCreateTypeEnums.CONTRACT.getCode())).in(AllowSaleRule::getRelateCode, contractCodes)).list();
    }
}

