/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.rule.service.internal;

import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleBusinessTrigger;
import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleProductTrigger;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleRuleRelateListService;
import com.biz.crm.dms.business.allow.sale.local.product.service.AllowSaleRuleProductService;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.service.AllowSaleRuleService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleTypeEnums;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AllowSaleRuleListAdapter {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleRuleListAdapter.class);
    @Autowired(required=false)
    private DimensionService dimensionService;
    @Autowired(required=false)
    private AllowSaleRuleProductService allowSaleRuleProductService;
    @Autowired(required=false)
    private AllowSaleRuleRelateListService allowSaleRuleRelateListService;
    @Autowired(required=false)
    private AllowSaleRuleService allowSaleRuleService;

    @Transactional
    public void createByRule(AllowSaleRule allowSaleRule) {
        this.handlerCreateByRule(allowSaleRule);
    }

    @Transactional
    public void deleteByRule(AllowSaleRule allowSaleRule) {
        Validate.notNull((Object)((Object)allowSaleRule), (String)"\u89c4\u5219\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getRuleCode(), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getDimensionType(), (String)"\u89c4\u5219\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String listType = this.dimensionService.getListType(allowSaleRule.getDimensionType());
        String ruleType = allowSaleRule.getRuleType();
        if (StringUtils.isBlank((CharSequence)ruleType)) {
            ruleType = AllowSaleRuleTypeEnums.ALLOW.getDictCode();
        }
        RelateRule relateRule = new RelateRule();
        relateRule.setListType(listType);
        relateRule.setRuleCode(allowSaleRule.getRuleCode());
        relateRule.setRuleType(ruleType);
        this.allowSaleRuleRelateListService.deleteByRule(relateRule);
    }

    @Transactional
    public void createByProduct(AllowSaleRuleProductTrigger product) {
        this.validateProduct(product);
        List<AllowSaleRuleRelateList> list = this.findByProduct(product);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.allowSaleRuleRelateListService.createByList(list);
    }

    @Transactional
    public void deleteByProduct(AllowSaleRuleProductTrigger product) {
        this.validateProduct(product);
        List<AllowSaleRuleRelateList> list = this.findByProduct(product);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.allowSaleRuleRelateListService.deleteByList(list);
    }

    @Transactional
    public void createByBusiness(AllowSaleRuleBusinessTrigger business) {
        this.validateBusiness(business);
        List<AllowSaleRuleRelateList> list = this.findByBusiness(business);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.allowSaleRuleRelateListService.createByList(list);
    }

    @Transactional
    public void deleteByBusiness(AllowSaleRuleBusinessTrigger business) {
        this.validateBusiness(business);
        List<AllowSaleRuleRelateList> list = this.findByBusiness(business);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.allowSaleRuleRelateListService.deleteByList(list);
    }

    private void handlerCreateByRule(AllowSaleRule allowSaleRule) {
        this.validateUpdateData(allowSaleRule);
        AllowSaleDimensionTypeEnums ruleTypeEnums = AllowSaleDimensionTypeEnums.findByCode((String)allowSaleRule.getDimensionType());
        Validate.notNull((Object)ruleTypeEnums, (String)"\u975e\u6cd5\u7684\u89c4\u5219\u7ef4\u5ea6", (Object[])new Object[0]);
        AllowSaleListTypeEnums listTypeEnums = AllowSaleListTypeEnums.findByRuleType((String)allowSaleRule.getDimensionType());
        Validate.notNull((Object)listTypeEnums, (String)"\u975e\u6cd5\u7684\u89c4\u5219\u7ef4\u5ea6", (Object[])new Object[0]);
        Map<String, Set<String>> businessCodeMap = this.dimensionService.findRuleRelateBusinessCodesMapByRuleCodes(Lists.newArrayList((Object[])new String[]{allowSaleRule.getRuleCode()}), allowSaleRule.getDimensionType());
        Set<String> businessCodeSet = businessCodeMap.get(allowSaleRule.getRuleCode());
        if (CollectionUtils.isEmpty(businessCodeSet)) {
            log.info("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u6216\u7ec8\u7aef\u4fe1\u606f\uff0c\u65e0\u9700\u66f4\u65b0\u53ef\u8d2d\u6e05\u5355");
            this.deleteByRule(allowSaleRule);
            return;
        }
        Map<String, Set<String>> productCodeMap = this.allowSaleRuleProductService.findRuleRelateProductCodesMapByRuleCodes(Lists.newArrayList((Object[])new String[]{allowSaleRule.getRuleCode()}));
        Set<String> productCodeSet = productCodeMap.get(allowSaleRule.getRuleCode());
        if (CollectionUtils.isEmpty(productCodeSet)) {
            log.info("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u65e0\u9700\u66f4\u65b0\u53ef\u8d2d\u6e05\u5355");
            this.deleteByRule(allowSaleRule);
            return;
        }
        String listType = this.dimensionService.getListType(allowSaleRule.getDimensionType());
        String ruleCode = allowSaleRule.getRuleCode();
        String ruleType = allowSaleRule.getRuleType();
        if (StringUtils.isBlank((CharSequence)ruleType)) {
            ruleType = AllowSaleRuleTypeEnums.ALLOW.getDictCode();
        }
        RelateRule relateRule = new RelateRule();
        relateRule.setListType(listType);
        relateRule.setRuleCode(ruleCode);
        relateRule.setRuleType(ruleType);
        ArrayList list = Lists.newArrayListWithCapacity((int)(businessCodeSet.size() * productCodeSet.size()));
        for (String businessCode : businessCodeSet) {
            for (String productCode : productCodeSet) {
                AllowSaleRuleRelateList cur = new AllowSaleRuleRelateList();
                cur.setRuleCode(ruleCode);
                cur.setRuleType(ruleType);
                cur.setTenantCode(TenantUtils.getTenantCode());
                cur.setListType(listType);
                cur.setBusinessCode(businessCode);
                cur.setProductCode(productCode);
                cur.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                cur.setSubItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getRuleCode(), cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                list.add(cur);
            }
        }
        this.allowSaleRuleRelateListService.createByRule(relateRule, list);
    }

    private List<AllowSaleRuleRelateList> findByProduct(AllowSaleRuleProductTrigger product) {
        Sets.SetView unionSet;
        String productCode = product.getProductCode();
        String productLevelCode = product.getProductLevelCode();
        Map<String, Set<String>> productCodeRuleMap = this.allowSaleRuleProductService.findSkuRelateRuleCodesMapBySkuCodes(Lists.newArrayList((Object[])new String[]{productCode}));
        Set<String> set1 = productCodeRuleMap.getOrDefault(productCode, Sets.newHashSet());
        Set<Object> set2 = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)productLevelCode)) {
            Map<String, Set<String>> productLevelCodeRuleMap = this.allowSaleRuleProductService.findProductLevelRelateRuleCodesMapByProductLevelCodes(Lists.newArrayList((Object[])new String[]{productLevelCode}));
            set2 = productLevelCodeRuleMap.getOrDefault(productLevelCode, Sets.newHashSet());
        }
        if ((unionSet = Sets.union(set1, (Set)set2)).isEmpty()) {
            return Lists.newLinkedList();
        }
        List<AllowSaleRule> allowSaleRuleList = this.allowSaleRuleService.findByCodesAndTenantCode(Lists.newArrayList((Iterable)unionSet), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(allowSaleRuleList)) {
            return Lists.newLinkedList();
        }
        Map mapRule = allowSaleRuleList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleCode())).collect(Collectors.toMap(AllowSaleRule::getRuleCode, Function.identity(), (a, b) -> a));
        Map<String, Set<String>> mapRuleBusiness = this.findRuleBusiness(allowSaleRuleList);
        if (mapRuleBusiness.isEmpty()) {
            return Lists.newLinkedList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        LinkedList list = Lists.newLinkedList();
        for (Map.Entry<String, Set<String>> item : mapRuleBusiness.entrySet()) {
            String ruleCode = item.getKey();
            Set<String> businessCodeSet = item.getValue();
            AllowSaleRule rule = (AllowSaleRule)((Object)mapRule.get(ruleCode));
            if (StringUtils.isBlank((CharSequence)ruleCode) || CollectionUtils.isEmpty(businessCodeSet) || Objects.isNull((Object)rule)) continue;
            String listType = this.dimensionService.getListType(rule.getDimensionType());
            for (String businessCode : businessCodeSet) {
                AllowSaleRuleRelateList cur = new AllowSaleRuleRelateList();
                cur.setTenantCode(tenantCode);
                cur.setRuleType(rule.getRuleType());
                cur.setRuleCode(rule.getRuleCode());
                cur.setBusinessCode(businessCode);
                cur.setProductCode(productCode);
                cur.setListType(listType);
                cur.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                cur.setSubItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getRuleCode(), cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                RelateRule relateRule = new RelateRule();
                relateRule.setRuleType(cur.getRuleType());
                relateRule.setRuleCode(cur.getRuleCode());
                relateRule.setListType(cur.getListType());
                cur.setRule(relateRule);
                list.add(cur);
            }
        }
        return list;
    }

    private List<AllowSaleRuleRelateList> findByBusiness(AllowSaleRuleBusinessTrigger business) {
        Map<String, Set<String>> map;
        String dimensionType = business.getDimensionType();
        String businessCode = business.getBusinessCode();
        String relateTypeCode = business.getRelateTypeCode();
        String relateDimensionType = business.getRelateDimensionType();
        Map<String, Set<String>> map1 = this.dimensionService.findRelateRuleCodesMapByRelateCodes(Lists.newArrayList((Object[])new String[]{businessCode}), dimensionType);
        HashSet ruleCodeSet = Sets.newHashSet();
        if (!map1.isEmpty()) {
            ruleCodeSet.addAll((Collection)map1.getOrDefault(businessCode, Sets.newHashSet()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{relateTypeCode, relateDimensionType}) && !(map = this.dimensionService.findRelateRuleCodesMapByRelateCodes(Lists.newArrayList((Object[])new String[]{relateTypeCode}), relateDimensionType)).isEmpty()) {
            ruleCodeSet.addAll((Collection)map.getOrDefault(relateTypeCode, Sets.newHashSet()));
        }
        if (CollectionUtils.isEmpty((Collection)ruleCodeSet)) {
            return Lists.newLinkedList();
        }
        List<AllowSaleRule> allowSaleRuleList = this.allowSaleRuleService.findByCodesAndTenantCode(Lists.newArrayList((Iterable)ruleCodeSet), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(allowSaleRuleList)) {
            return Lists.newLinkedList();
        }
        Map mapRule = allowSaleRuleList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleCode())).collect(Collectors.toMap(AllowSaleRule::getRuleCode, Function.identity(), (a, b) -> a));
        Map<String, Set<String>> mapRuleProduct = this.allowSaleRuleProductService.findRuleRelateProductCodesMapByRuleCodes(Lists.newArrayList((Iterable)ruleCodeSet));
        if (mapRuleProduct.isEmpty()) {
            return Lists.newLinkedList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        LinkedList list = Lists.newLinkedList();
        for (Map.Entry<String, Set<String>> item : mapRuleProduct.entrySet()) {
            String ruleCode = item.getKey();
            Set<String> productCodeSet = item.getValue();
            AllowSaleRule rule = (AllowSaleRule)((Object)mapRule.get(ruleCode));
            if (StringUtils.isBlank((CharSequence)ruleCode) || CollectionUtils.isEmpty(productCodeSet) || Objects.isNull((Object)rule)) continue;
            String listType = this.dimensionService.getListType(rule.getDimensionType());
            for (String productCode : productCodeSet) {
                AllowSaleRuleRelateList cur = new AllowSaleRuleRelateList();
                cur.setTenantCode(tenantCode);
                cur.setRuleType(rule.getRuleType());
                cur.setRuleCode(rule.getRuleCode());
                cur.setBusinessCode(businessCode);
                cur.setProductCode(productCode);
                cur.setListType(listType);
                cur.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                cur.setSubItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getRuleCode(), cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                RelateRule relateRule = new RelateRule();
                relateRule.setRuleType(cur.getRuleType());
                relateRule.setRuleCode(cur.getRuleCode());
                relateRule.setListType(cur.getListType());
                cur.setRule(relateRule);
                list.add(cur);
            }
        }
        return list;
    }

    private Map<String, Set<String>> findRuleBusiness(List<AllowSaleRule> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map dimensionTypeMap = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getDimensionType(), a.getRuleCode()})).collect(Collectors.groupingBy(AllowSaleRule::getDimensionType, Collectors.mapping(AllowSaleRule::getRuleCode, Collectors.toSet())));
        if (dimensionTypeMap.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (Map.Entry item : dimensionTypeMap.entrySet()) {
            Map<String, Set<String>> curMap = this.dimensionService.findRuleRelateBusinessCodesMapByRuleCodes(Lists.newArrayList((Iterable)item.getValue()), item.getKey());
            if (curMap.isEmpty()) continue;
            for (Map.Entry<String, Set<String>> sub : curMap.entrySet()) {
                map.put(sub.getKey(), sub.getValue());
            }
        }
        return map;
    }

    private void validateUpdateData(AllowSaleRule allowSaleRule) {
        Validate.notNull((Object)((Object)allowSaleRule), (String)"\u89c4\u5219\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getRuleCode(), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getDimensionType(), (String)"\u89c4\u5219\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getCreateType(), (String)"\u521b\u5efa\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)allowSaleRule.getDimensionJson(), (String)"\u7ef4\u5ea6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(allowSaleRule.getProductList()), (String)"\u53ef\u8d2d\u5546\u54c1\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validateProduct(AllowSaleRuleProductTrigger product) {
        Validate.notNull((Object)product, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)product.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)product.getProductLevelCode())) {
            product.setProductLevelCode("");
        }
    }

    private void validateBusiness(AllowSaleRuleBusinessTrigger business) {
        Validate.notNull((Object)business, (String)"\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)business.getDimensionType(), (String)"\u4e1a\u52a1\u7ef4\u5ea6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)business.getBusinessCode(), (String)"\u7ef4\u5ea6\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)business.getRelateTypeCode())) {
            business.setRelateTypeCode("");
            business.setRelateDimensionType("");
        } else {
            Validate.notEmpty((CharSequence)business.getRelateDimensionType(), (String)"\u5173\u8054\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

