/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.util;

import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.DimensionDictVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AllowSaleUtil {
    private AllowSaleUtil() {
    }

    public static AllowSaleList findByItemKey(String itemKey) {
        if (StringUtils.isBlank((CharSequence)itemKey) || !itemKey.contains(":")) {
            return null;
        }
        String[] split = StringUtils.split((String)itemKey, (String)":");
        if (split.length == 3) {
            AllowSaleList allowSaleList = new AllowSaleList();
            allowSaleList.setListType(split[0]);
            allowSaleList.setBusinessCode(split[1]);
            allowSaleList.setProductCode(split[2]);
            return allowSaleList;
        }
        return null;
    }

    public static Map<String, Set<String>> findRelateRule(List<String> queryCodeList, Map<String, String> ruleCodeMap, Map<String, Set<String>> mapRule) {
        if (CollectionUtils.isEmpty(queryCodeList) || ruleCodeMap.isEmpty() || mapRule.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (String item : queryCodeList) {
            String orgRuleCode = ruleCodeMap.get(item);
            if (StringUtils.isBlank((CharSequence)orgRuleCode)) continue;
            HashSet rule = Sets.newHashSet();
            for (Map.Entry<String, Set<String>> sub : mapRule.entrySet()) {
                String cur = ruleCodeMap.get(sub.getKey());
                if (StringUtils.isBlank((CharSequence)cur) || !orgRuleCode.startsWith(cur) || CollectionUtils.isEmpty((Collection)sub.getValue())) continue;
                rule.addAll((Collection)sub.getValue());
            }
            if (!CollectionUtils.isNotEmpty((Collection)rule)) continue;
            map.put(item, rule);
        }
        return map;
    }

    public static Map<String, Set<String>> findRelateBusiness(Map<String, String> curRuleMap, Map<String, Set<String>> mapBusinessRule) {
        if (curRuleMap.isEmpty() || mapBusinessRule.isEmpty()) {
            return Maps.newHashMap();
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> item : mapBusinessRule.entrySet()) {
            for (String string : item.getValue()) {
                if (StringUtils.isBlank((CharSequence)string)) continue;
                DimensionDictVo dictVo = new DimensionDictVo();
                dictVo.setDimensionType(item.getKey());
                dictVo.setDimensionDesc(string);
                list.add(dictVo);
            }
        }
        Map mapTerminalRuleConvert = list.stream().collect(Collectors.groupingBy(DimensionDictVo::getDimensionDesc, Collectors.mapping(DimensionDictVo::getDimensionType, Collectors.toSet())));
        if (mapTerminalRuleConvert.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : curRuleMap.entrySet()) {
            String s1 = (String)entry.getValue();
            HashSet cur = Sets.newHashSet();
            for (Map.Entry sub : mapTerminalRuleConvert.entrySet()) {
                String s2 = sub.getKey();
                if (!s2.startsWith(s1)) continue;
                cur.addAll(sub.getValue());
            }
            if (CollectionUtils.isEmpty((Collection)cur)) continue;
            map.put((String)entry.getKey(), cur);
        }
        return map;
    }
}

