package com.biz.crm.dms.business.allow.sale.local.dimension.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.Dimension;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.register.AllowSaleRuleDimensionRegister;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.DimensionDictVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 允销规则维度基座实现
 *
 * @author sunx
 * @date 2021/11/23
 */
@Service
@Slf4j
public class DimensionServiceImpl implements DimensionService {

  @Autowired(required = false)
  private List<AllowSaleRuleDimensionRegister<? extends Dimension>> registers;

  @Override
  public List<DimensionDictVo> findDimensionDictVoList() {
    if (CollectionUtils.isEmpty(registers)) {
      return Lists.newLinkedList();
    }
    List<DimensionDictVo> re = Lists.newArrayList();
    registers.stream()
        .sorted(Comparator.comparing(AllowSaleRuleDimensionRegister::sort))
        .forEach(
            a -> {
              DimensionDictVo cur = new DimensionDictVo();
              cur.setDimensionType(a.getType());
              cur.setDimensionDesc(a.getTypeDesc());
              re.add(cur);
            });
    return re;
  }

  @Override
  public String getListType(String dimensionType) {
    return this.getDimensionRegister(dimensionType).getListType();
  }

  @Override
  public void saveDimension(JSONObject data, String dimensionType) {
    AllowSaleRuleDimensionRegister<? extends Dimension> register =
        this.getDimensionRegister(dimensionType);
    register.saveDimensionDetail(JsonUtils.convert(data, register.getDimensionClass()));
  }

  @Override
  public JSONObject findByRuleCode(String ruleCode, String dimensionType) {
    AllowSaleRuleDimensionRegister<? extends Dimension> register =
        this.getDimensionRegister(dimensionType);
    return JsonUtils.toJSONObject(register.findByRuleCode(ruleCode));
  }

  @Override
  public Map<String, Set<String>> findRelateRuleCodesMapByRelateCodes(
      List<String> relateCodeList, String dimensionType) {
    return this.getDimensionRegister(dimensionType)
        .findRelateRuleCodesMapByRelateCodes(relateCodeList);
  }

  @Override
  public Map<String, Set<String>> findRuleRelateBusinessCodesMapByRuleCodes(
      List<String> ruleCodeList, String dimensionType) {
    return this.getDimensionRegister(dimensionType)
        .findRuleRelateBusinessCodesMapByRuleCodes(ruleCodeList);
  }

  /**
   * 根据维度系统编码获取具体的维度注册信息
   *
   * @param type
   * @return
   */
  private AllowSaleRuleDimensionRegister<? extends Dimension> getDimensionRegister(String type) {
    Validate.notBlank(type, "维度系统编码不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(registers), "无可用的允销规则维度注册信息");
    AllowSaleRuleDimensionRegister<? extends Dimension> register = null;
    for (AllowSaleRuleDimensionRegister<? extends Dimension> cur : registers) {
      if (cur.getType().equals(type)) {
        register = cur;
        break;
      }
    }
    Validate.notNull(register, "未获取到匹配的允销维度注册信息");
    return register;
  }
}
