package com.biz.crm.dms.business.allow.sale.local.element.service.internal;

import com.biz.crm.dms.business.allow.sale.local.element.entity.AllowSaleElement;
import com.biz.crm.dms.business.allow.sale.local.element.service.AllowSaleElementService;
import com.biz.crm.dms.business.allow.sale.sdk.element.service.AllowSaleElementVoService;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 合同可购清单要素SDK接口实现
 *
 * @author pengxi
 * @date 2022-09-16 21:50:37
 */
@Slf4j
@Service
public class AllowSaleElementVoServiceImpl implements AllowSaleElementVoService {

  @Autowired(required = false) private AllowSaleElementService allowSaleElementService;

  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;

  @Override
  public AllowSaleElementDataVo findByContractCode(String contractCode) {
    return this.allowSaleElementService.findByContractCode(contractCode);
  }

  @Override
  public List<AllowSaleElementVo> findByContractCodeList(List<String> contractCodeList) {
    List<AllowSaleElement> allowSaleElements = this.allowSaleElementService.findByContractCodeList(contractCodeList);
    if (CollectionUtils.isEmpty(allowSaleElements)) {
      return null;
    }
    return (List<AllowSaleElementVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
        allowSaleElements, AllowSaleElement.class, AllowSaleElementVo.class, HashSet.class, ArrayList.class);
  }

}
