package com.biz.crm.dms.business.allow.sale.local.list.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListProductPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListProductVoService;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListProductVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 允销清单信息: AllowSaleListProductVo: 允销清单信息
 *
 * @author sunx
 * @date 2022/1/6
 */
@Slf4j
@Api(tags = "允销清单信息: AllowSaleListProductVo: 允销清单信息")
@RestController
@RequestMapping(value = {"/v1/allowSaleList/allowSaleListProduct"})
public class AllowSaleListProductVoController {

  @Autowired(required = false)
  private AllowSaleListProductVoService allowSaleListProductVoService;

  /**
   * 查询分页列表
   *
   * @param pageable 分页
   * @param paginationDto 查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<AllowSaleListProductVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, AllowSaleListProductPaginationDto paginationDto) {
    try {
      Page<AllowSaleListProductVo> result =
          this.allowSaleListProductVoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
