package com.biz.crm.dms.business.allow.sale.local.list.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListPaginationDto;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 允销清单信息(AllowSaleList)表数据库访问层
 *
 * @author sunx
 * @date 2021-11-19 15:15:41
 */
public interface AllowSaleListMapper extends BaseMapper<AllowSaleList> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<AllowSaleList> findByConditions(
      Page<AllowSaleList> page, @Param("dto") AllowSaleListPaginationDto dto);

  /**
   * 根据清单类型+规则类型获取业务编码集合
   *
   * @param listType 清单类型
   * @param ruleType 规则类型
   * @return
   */
  Set<String> findBusinessCodesByListTypeAndRuleType(
      @Param("listType") String listType, @Param("ruleType") String ruleType);

  /**
   * 刷新关联可购规则数量
   *
   * @param ruleCode 规则编码
   * @param offset 偏移量
   * @param tenantCode 租户
   */
  void updateByAllowRule(
      @Param("ruleCode") String ruleCode,
      @Param("offset") Integer offset,
      @Param("tenantCode") String tenantCode);

  /**
   * 刷新关联不可购规则数量
   *
   * @param ruleCode 规则编码
   * @param offset 偏移量
   * @param tenantCode 租户
   */
  void updateByNotAllowRule(
      @Param("ruleCode") String ruleCode,
      @Param("offset") Integer offset,
      @Param("tenantCode") String tenantCode);

  /**
   * 获取已经存在的itemKey集合
   *
   * @param itemKeys 行记录编码
   * @param tenantCode 租户
   * @return
   */
  Set<String> findExistsKeys(
      @Param("itemKeys") Set<String> itemKeys, @Param("tenantCode") String tenantCode);
}
