package com.biz.crm.dms.business.allow.sale.local.list.service;

import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListModifyNoticeDto;
import java.util.Set;

/**
 * 允销缓存相关接口
 *
 * @author sunx
 * @date 2022/6/20
 */
public interface AllowSaleListCacheService {

  /**
   * 通知进行功能缓存的清理
   *
   * @param dto 通知信息
   */
  void notifyCacheRefresh(AllowSaleListModifyNoticeDto dto);

  /**
   * 清除功能缓存(指定的缓存)
   *
   * @param dto 通知信息
   */
  void clearCache(AllowSaleListModifyNoticeDto dto);

  /**
   * 获取缓存中的值
   *
   * @param listType 清单类型
   * @param businessCode 业务编码
   * @return
   */
  Set<String> findCache(String listType, String businessCode);
}
