package com.biz.crm.dms.business.allow.sale.local.list.service;

import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import java.util.List;

/**
 * 可购规则与可购清单关系服务接口(这里的方法只能在规则信息维护及事件监听调用)
 *
 * @author sunx
 * @date 2022-06-24 15:29:39
 */
public interface AllowSaleRuleRelateListService {

  /**
   * 根据规则创建关系数据（在规则新增、编辑、启用操作时调用）
   *
   * @param rule 关联规则
   * @param list 清单数据
   */
  void createByRule(RelateRule rule, List<AllowSaleRuleRelateList> list);

  /**
   * 根据规则删除关系数据（在规则删除、禁用时调用）
   *
   * @param rule 关联规则
   */
  void deleteByRule(RelateRule rule);

  /**
   * 根据关系数据执行新增操作（规则对应的维度信息变化时调用）
   *
   * @param list 清单数据
   */
  void createByList(List<AllowSaleRuleRelateList> list);

  /**
   * 根据关系数据执行删除操作（规则对应的维度信息变化时调用）
   *
   * @param list 清单数据
   */
  void deleteByList(List<AllowSaleRuleRelateList> list);
}
