package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 允销清单信息SDK接口实现
 *
 * <p>可购清单是确定人货关系的唯一凭证
 *
 * <p>主要属性businessCode+listType+productCode
 *
 * <p>productCode确定货
 *
 * <p>businessCode+listType确定人
 *
 * <p>businessCode 根据业务不同可以是终端、客户、用户等
 *
 * <p>listType 为业务区分，和businessCode业务匹配
 *
 * @author sunx
 * @date 2021/11/22
 */
@Service
public class AllowSaleListVoServiceImpl implements AllowSaleListVoService {

  @Autowired(required = false)
  private AllowSaleListService allowSaleListService;

  @Override
  public List<String> findAllowSaleProductCodes(ValidateAllowSaleProductDto dto) {
    if (Objects.isNull(dto)
        || StringUtils.isBlank(dto.getListType())
        || StringUtils.isBlank(dto.getBusinessCode())) {
      return Lists.newLinkedList();
    }
    final List<String> list = this.allowSaleListService.findAllowSaleProductCodes(dto);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }
    final Set<String> productCodes = Sets.newHashSet(list);
    if (CollectionUtils.isEmpty(productCodes)) {
      return Lists.newLinkedList();
    }
    if (CollectionUtils.isNotEmpty(dto.getProductCodeList())) {
      Set<String> set = Sets.newHashSet(dto.getProductCodeList());
      final SetView<String> difference = Sets.intersection(productCodes, set);
      if (difference.isEmpty()) {
        return Lists.newLinkedList();
      }
      return Lists.newArrayList(difference);
    }
    return Lists.newArrayList(productCodes);
  }
}
