package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleBusinessTrigger;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerRelateOrgEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerRelateOrgEventListener;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 经销商组织绑定事件实现
 *
 * @author sunx
 * @date 2022/5/26
 */
@Component
public class AllowCustomerRelateOrgEventListenerImpl implements CustomerRelateOrgEventListener {
  @Autowired(required = false)
  private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

  @Override
  @Transactional
  public void onRebind(CustomerRelateOrgEventDto dto) {
    Validate.notNull(dto, "经销商参数不能为空");
    final CustomerVo vo = dto.getCustomerVo();
    Validate.notNull(dto, "经销商参数不能为空");
    final String oldOrgCode = Optional.ofNullable(dto.getOldOrgCode()).orElse(StringUtils.EMPTY);
    final String orgCode = Optional.ofNullable(dto.getNewOrgCode()).orElse(StringUtils.EMPTY);
    if (!ProcessStatusEnum.PASS.getDictCode().equals(vo.getProcessStatus())
        || oldOrgCode.equals(orgCode)) {
      return;
    }
    if (StringUtils.isNotBlank(oldOrgCode)) {
      final CustomerRelateOrgVo cur = new CustomerRelateOrgVo();
      cur.setOrgCode(oldOrgCode);
      List<CustomerRelateOrgVo> orgList = Lists.newArrayList(cur);
      vo.setOrgList(orgList);
      this.handlerAllowSale(vo, Boolean.FALSE);
    }
    if (StringUtils.isNotBlank(orgCode)) {
      final CustomerRelateOrgVo cur = new CustomerRelateOrgVo();
      cur.setOrgCode(orgCode);
      List<CustomerRelateOrgVo> orgList = Lists.newArrayList(cur);
      vo.setOrgList(orgList);
      this.handlerAllowSale(vo, Boolean.TRUE);
    }
  }

  /**
   * 根据经销商信息操作可购信息
   *
   * @param vo
   * @param createFlag
   */
  private void handlerAllowSale(CustomerVo vo, Boolean createFlag) {
    if (Objects.isNull(vo) || StringUtils.isBlank(vo.getCustomerCode())) {
      return;
    }
    final String customerCode = vo.getCustomerCode();
    final List<CustomerRelateOrgVo> orgList = vo.getOrgList();
    Set<String> orgCodeSet = Sets.newHashSet();
    if (!CollectionUtils.isEmpty(orgList)) {
      orgCodeSet =
          orgList.stream()
              .filter(a -> StringUtils.isNotBlank(a.getOrgCode()))
              .map(CustomerRelateOrgVo::getOrgCode)
              .collect(Collectors.toSet());
    }
    if (CollectionUtils.isEmpty(orgCodeSet)) {
      final AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
      business.setBusinessCode(customerCode);
      business.setDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER.getCode());
      if (Boolean.TRUE.equals(createFlag)) {
        this.allowSaleRuleListAdapter.createByBusiness(business);
      } else {
        this.allowSaleRuleListAdapter.deleteByBusiness(business);
      }
    } else {
      for (String orgCode : orgCodeSet) {
        final AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
        business.setBusinessCode(customerCode);
        business.setDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER.getCode());
        business.setRelateTypeCode(orgCode);
        business.setRelateDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER_ORG.getCode());
        if (Boolean.TRUE.equals(createFlag)) {
          this.allowSaleRuleListAdapter.createByBusiness(business);
        } else {
          this.allowSaleRuleListAdapter.deleteByBusiness(business);
        }
      }
    }
  }
}
