package com.biz.crm.dms.business.allow.sale.local.product.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import com.biz.crm.dms.business.allow.sale.local.product.mapper.AllowSaleRuleProductMapper;
import com.biz.crm.dms.business.allow.sale.local.product.model.ProductRelateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 允销规则关联的可购商品信息(repository)
 *
 * @author sunx
 * @date 2021-11-19 15:17:32
 */
@Component
public class AllowSaleRuleProductRepository
    extends ServiceImpl<AllowSaleRuleProductMapper, AllowSaleRuleProduct> {

  /**
   * 根据规则获取关联商品配置信息
   *
   * @param ruleCodeList 规则编码
   * @return
   */
  public List<AllowSaleRuleProduct> findByRuleCodes(List<String> ruleCodeList) {
    return this.lambdaQuery()
        .eq(AllowSaleRuleProduct::getTenantCode, TenantUtils.getTenantCode())
        .in(AllowSaleRuleProduct::getRuleCode, ruleCodeList)
        .list();
  }

  /**
   * 根据规则编码删除配置信息
   *
   * @param ruleCode 规则编码
   */
  public void deleteByRuleCode(String ruleCode) {
    LambdaQueryWrapper<AllowSaleRuleProduct> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(AllowSaleRuleProduct::getTenantCode, TenantUtils.getTenantCode())
        .eq(AllowSaleRuleProduct::getRuleCode, ruleCode);
    baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据关联类型+关联业务编码获取配置信息
   *
   * @param relateType 关联类型
   * @param relateCodeList 关联业务编码
   * @return
   */
  public List<ProductRelateVo> findProductRelateVoListByRelateTypeAndRelateCodes(
      String relateType, List<String> relateCodeList) {
    return this.baseMapper.findProductRelateVoListByRelateTypeAndRelateCodes(
        TenantUtils.getTenantCode(),
        relateType,
        DelFlagStatusEnum.NORMAL.getCode(),
        relateCodeList);
  }
}
