package com.biz.crm.dms.business.allow.sale.local.rule.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.sdk.rule.dto.AllowSaleRulePaginationDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 允销规则主细信息(AllowSaleRule)表服务接口
 *
 * @author sunx
 * @date 2021-11-19 15:16:25
 */
public interface AllowSaleRuleService {

  /**
   * 分页条件查询
   *
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<AllowSaleRule> findByConditions(Pageable pageable, AllowSaleRulePaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id 主键
   * @return
   */
  AllowSaleRule findDetailById(String id);

  /**
   * 创建
   *
   * @param allowSaleRule 规则
   * @return
   */
  AllowSaleRule create(AllowSaleRule allowSaleRule);

  /**
   * 更新
   *
   * @param allowSaleRule 规则
   * @return
   */
  AllowSaleRule update(AllowSaleRule allowSaleRule);

  /**
   * 逻辑删除
   *
   * @param ids 主键
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据允销规则编码获取允销规则主要信息
   *
   * @param ruleCodeList 规则编码
   * @param tenantCode 租户
   * @return
   */
  List<AllowSaleRule> findByCodesAndTenantCode(List<String> ruleCodeList, String tenantCode);

  /**
   * 启用
   *
   * @param ids 主键
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   *
   * @param ids 主键
   */
  void disableBatch(List<String> ids);

  /**
   * 根据合同更新对应的规则状态
   *
   * @param contractCodes 合同编码
   * @param enableStatus 启禁用状态
   */
  void updateByContractCodesAndEnableStatus(List<String> contractCodes, String enableStatus);

  /**
   * 根据合同编码获取可购规则
   *
   * @param contractCodes 合同编码
   * @return
   */
  List<AllowSaleRule> findByContractCodes(Set<String> contractCodes);
}
