/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.dimension.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.Dimension;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.register.AllowSaleRuleDimensionRegister;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.DimensionDictVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DimensionServiceImpl
implements DimensionService {
    private static final Logger log = LoggerFactory.getLogger(DimensionServiceImpl.class);
    @Autowired(required=false)
    private List<AllowSaleRuleDimensionRegister<? extends Dimension>> registers;

    @Override
    public List<DimensionDictVo> findDimensionDictVoList() {
        if (CollectionUtils.isEmpty(this.registers)) {
            return Lists.newLinkedList();
        }
        ArrayList re = Lists.newArrayList();
        this.registers.stream().sorted(Comparator.comparing(AllowSaleRuleDimensionRegister::sort)).forEach(a -> {
            DimensionDictVo cur = new DimensionDictVo();
            cur.setDimensionType(a.getType());
            cur.setDimensionDesc(a.getTypeDesc());
            re.add(cur);
        });
        return re;
    }

    @Override
    public String getListType(String dimensionType) {
        return this.getDimensionRegister(dimensionType).getListType();
    }

    @Override
    public void saveDimension(JSONObject data, String dimensionType) {
        AllowSaleRuleDimensionRegister<? extends Dimension> register = this.getDimensionRegister(dimensionType);
        register.saveDimensionDetail((Dimension)JsonUtils.convert((Object)data, (Class)register.getDimensionClass()));
    }

    @Override
    public JSONObject findByRuleCode(String ruleCode, String dimensionType) {
        AllowSaleRuleDimensionRegister<? extends Dimension> register = this.getDimensionRegister(dimensionType);
        return JsonUtils.toJSONObject((Object)register.findByRuleCode(ruleCode));
    }

    @Override
    public Map<String, Set<String>> findRelateRuleCodesMapByRelateCodes(List<String> relateCodeList, String dimensionType) {
        return this.getDimensionRegister(dimensionType).findRelateRuleCodesMapByRelateCodes(relateCodeList);
    }

    @Override
    public Map<String, Set<String>> findRuleRelateBusinessCodesMapByRuleCodes(List<String> ruleCodeList, String dimensionType) {
        return this.getDimensionRegister(dimensionType).findRuleRelateBusinessCodesMapByRuleCodes(ruleCodeList);
    }

    private AllowSaleRuleDimensionRegister<? extends Dimension> getDimensionRegister(String type) {
        Validate.notBlank((CharSequence)type, (String)"\u7ef4\u5ea6\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(this.registers), (String)"\u65e0\u53ef\u7528\u7684\u5141\u9500\u89c4\u5219\u7ef4\u5ea6\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        AllowSaleRuleDimensionRegister<? extends Dimension> register = null;
        for (AllowSaleRuleDimensionRegister<? extends Dimension> cur : this.registers) {
            if (!cur.getType().equals(type)) continue;
            register = cur;
            break;
        }
        Validate.notNull(register, (String)"\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u5141\u9500\u7ef4\u5ea6\u6ce8\u518c\u4fe1\u606f", (Object[])new Object[0]);
        return register;
    }
}

