/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.dimension.service.register;

import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.service.AllowSaleRuleDetailService;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.Dimension;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.register.AllowSaleRuleDimensionRegister;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.customer.CustomerDimensionItemVo;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.customer.CustomerDimensionVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CustomerDimensionVoRegisterImpl
implements AllowSaleRuleDimensionRegister<CustomerDimensionVo> {
    private static final Logger log = LoggerFactory.getLogger(CustomerDimensionVoRegisterImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleDetailService allowSaleRuleDetailService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public String getType() {
        return AllowSaleDimensionTypeEnums.CUSTOMER.getCode();
    }

    public String getTypeDesc() {
        return AllowSaleDimensionTypeEnums.CUSTOMER.getDesc();
    }

    public int sort() {
        return 1;
    }

    public Class<CustomerDimensionVo> getDimensionClass() {
        return CustomerDimensionVo.class;
    }

    public String getListType() {
        return AllowSaleListTypeEnums.CUSTOMER.getCode();
    }

    @Transactional
    public void saveDimensionDetail(Dimension dimension) {
        Validate.notNull((Object)dimension, (String)"\u5ba2\u6237\u7ef4\u5ea6\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerDimensionVo vo = (CustomerDimensionVo)dimension;
        Validate.notBlank((CharSequence)vo.getRuleCode(), (String)"\u5141\u9500\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)vo.getList()), (String)"\u5ba2\u6237\u7ef4\u5ea6\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList list = Lists.newArrayList();
        vo.getList().forEach(a -> {
            AllowSaleRuleDetail cur = new AllowSaleRuleDetail();
            cur.setRelateCode(a.getCustomerCode());
            cur.setRuleCode(vo.getRuleCode());
            list.add(cur);
        });
        this.allowSaleRuleDetailService.batchSave(list);
    }

    public CustomerDimensionVo findByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return null;
        }
        List<AllowSaleRuleDetail> list = this.allowSaleRuleDetailService.findByRuleCodes(Lists.newArrayList((Object[])new String[]{ruleCode}));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List customerCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(AllowSaleRuleDetail::getRelateCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return null;
        }
        List customerVoList = this.customerVoService.findByCustomerCodes(customerCodeList);
        if (CollectionUtils.isEmpty((Collection)customerVoList)) {
            return null;
        }
        Map<String, String> customerNameMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, CustomerVo::getCustomerName, (a, b) -> a));
        CustomerDimensionVo vo = new CustomerDimensionVo();
        ArrayList subList = Lists.newArrayList();
        list.forEach(a -> {
            CustomerDimensionItemVo cur = new CustomerDimensionItemVo();
            cur.setCustomerCode(a.getRelateCode());
            cur.setCustomerName(customerNameMap.getOrDefault(a.getRelateCode(), ""));
            subList.add(cur);
        });
        vo.setList((List)subList);
        return vo;
    }

    public Map<String, Set<String>> findRelateRuleCodesMapByRelateCodes(List<String> relateCodeList) {
        if (CollectionUtils.isEmpty(relateCodeList)) {
            return Maps.newHashMap();
        }
        List<DetailRelateVo> list = this.allowSaleRuleDetailService.findByDimensionTypeAndRelateCodes(this.getType(), relateCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()})).collect(Collectors.groupingBy(DetailRelateVo::getRelateCode, Collectors.mapping(DetailRelateVo::getRuleCode, Collectors.toSet())));
    }

    public Map<String, Set<String>> findRuleRelateBusinessCodesMapByRuleCodes(List<String> ruleCodeList) {
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Maps.newHashMap();
        }
        List<AllowSaleRuleDetail> list = this.allowSaleRuleDetailService.findByRuleCodes(ruleCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Set relateCodeSet = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateCode())).map(AllowSaleRuleDetail::getRelateCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(relateCodeSet)) {
            return Maps.newHashMap();
        }
        CustomerQueryDto queryDto = new CustomerQueryDto();
        queryDto.setCustomerCodeSet(relateCodeSet);
        Set customerCodeSet = this.customerVoService.findByCustomerQueryDto(queryDto);
        if (CollectionUtils.isEmpty((Collection)customerCodeSet)) {
            return Maps.newHashMap();
        }
        return list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getRelateCode(), a.getRuleCode()}) && customerCodeSet.contains(a.getRelateCode())).collect(Collectors.groupingBy(AllowSaleRuleDetail::getRuleCode, Collectors.mapping(AllowSaleRuleDetail::getRelateCode, Collectors.toSet())));
    }
}

