/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.element.service.internal;

import com.biz.crm.dms.business.allow.sale.local.element.entity.AllowSaleElement;
import com.biz.crm.dms.business.allow.sale.local.element.repository.AllowSaleElementRepository;
import com.biz.crm.dms.business.allow.sale.local.element.service.AllowSaleElementService;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleElementEnums;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AllowSaleElementServiceImpl
implements AllowSaleElementService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleElementServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleElementRepository allowSaleElementRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public AllowSaleElementDataVo findByContractCode(String contractcode) {
        if (StringUtils.isBlank((CharSequence)contractcode)) {
            return null;
        }
        List<AllowSaleElement> allowSaleElements = this.allowSaleElementRepository.findByContractCode(contractcode);
        if (CollectionUtils.isEmpty(allowSaleElements)) {
            return null;
        }
        AllowSaleElementDataVo vo = new AllowSaleElementDataVo();
        List contractVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(allowSaleElements, AllowSaleElement.class, AllowSaleElementVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<AllowSaleElementVo>> elementVoMap = contractVos.stream().collect(Collectors.groupingBy(AllowSaleElementVo::getAllowSaleType));
        vo.setAllowSaleMap(elementVoMap);
        return vo;
    }

    @Override
    public List<AllowSaleElement> findByContractCodeList(List<String> contractCodeList) {
        if (CollectionUtils.isEmpty(contractCodeList)) {
            return null;
        }
        return this.allowSaleElementRepository.findByContractCodeList(contractCodeList);
    }

    @Override
    @Transactional
    public AllowSaleElementDataVo createAllowSaleElement(String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, allowSaleElementDataVo);
        ArrayList allowSaleElementVos = new ArrayList();
        allowSaleElementDataVo.getAllowSaleMap().forEach((k, v) -> allowSaleElementVos.addAll(v));
        List allowSaleElements = (List)this.nebulaToolkitService.copyCollectionByWhiteList(allowSaleElementVos, AllowSaleElementVo.class, AllowSaleElement.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)allowSaleElements)) {
            allowSaleElements.forEach(allowSaleElement -> {
                allowSaleElement.setTenantCode(TenantUtils.getTenantCode());
                allowSaleElement.setContractcode(contractCode);
            });
        }
        this.allowSaleElementRepository.saveBatch(allowSaleElements);
        return allowSaleElementDataVo;
    }

    @Override
    @Transactional
    public AllowSaleElementDataVo updateAllowSaleElement(String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode) {
        this.validateSaveOrUpdate(contractCode, allowSaleElementDataVo);
        ArrayList allowSaleElementVos = new ArrayList();
        allowSaleElementDataVo.getAllowSaleMap().forEach((k, v) -> allowSaleElementVos.addAll(v));
        this.allowSaleElementRepository.deleteByContractCode(contractCode);
        List allowSaleElements = (List)this.nebulaToolkitService.copyCollectionByWhiteList(allowSaleElementVos, AllowSaleElementVo.class, AllowSaleElement.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)allowSaleElements)) {
            allowSaleElements.forEach(allowSaleElement -> {
                allowSaleElement.setId(null);
                allowSaleElement.setTenantCode(TenantUtils.getTenantCode());
                allowSaleElement.setContractcode(contractCode);
            });
        }
        this.allowSaleElementRepository.saveBatch(allowSaleElements);
        return allowSaleElementDataVo;
    }

    private void validateSaveOrUpdate(String contractCode, AllowSaleElementDataVo allowSaleElementDataVo) {
        Validate.notBlank((CharSequence)contractCode, (String)"\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)allowSaleElementDataVo, (String)"\u5408\u540c\u7ec6\u5219\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)allowSaleElementDataVo.getAllowSaleMap(), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        allowSaleElementDataVo.getAllowSaleMap().forEach((k, v) -> {
            if (!CollectionUtils.isEmpty((Collection)v)) {
                v.forEach(allowSaleElementVo -> {
                    Validate.notNull((Object)allowSaleElementVo.getAllowSaleType(), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    Validate.isTrue((boolean)AllowSaleElementEnums.exists((String)allowSaleElementVo.getAllowSaleType()), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                    if (AllowSaleElementEnums.PRODUCT.getCode().equals(allowSaleElementVo.getAllowSaleType())) {
                        Validate.notNull((Object)allowSaleElementVo.getProductCode(), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u4ea7\u54c1\u7f16\u7801\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                        Validate.notNull((Object)allowSaleElementVo.getProductName(), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u4ea7\u54c1\u540d\u79f0\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                    }
                    if (AllowSaleElementEnums.PRODUCT_LEVEL.getCode().equals(allowSaleElementVo.getAllowSaleType())) {
                        Validate.notNull((Object)allowSaleElementVo.getProductLevelCode(), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                        Validate.notNull((Object)allowSaleElementVo.getProductLevelName(), (String)"\u5408\u540c\u53ef\u8d2d\u6e05\u5355\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                    }
                });
            }
        });
    }
}

