/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.local.list.mapper.AllowSaleListMapper;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AllowSaleListRepository
extends ServiceImpl<AllowSaleListMapper, AllowSaleList> {
    private static final Integer SIZE = 1000;

    public Page<AllowSaleList> findByConditions(Page<AllowSaleList> page, AllowSaleListPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((AllowSaleListMapper)this.baseMapper).findByConditions(page, dto);
    }

    public void deleteByIds(List<String> ids) {
        for (List list : Lists.partition(ids, (int)SIZE)) {
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.in(UuidEntity::getId, (Collection)list);
            ((AllowSaleListMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
        }
    }

    public List<String> findAllowSaleProductCodes(ValidateAllowSaleProductDto dto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AllowSaleList::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AllowSaleList::getNotAllow, (Object)0)).ge(AllowSaleList::getAllow, (Object)1)).eq(AllowSaleList::getListType, (Object)dto.getListType())).eq(AllowSaleList::getBusinessCode, (Object)dto.getBusinessCode())).in(CollectionUtils.isNotEmpty((Collection)dto.getProductCodeList()), AllowSaleList::getProductCode, (Collection)dto.getProductCodeList())).select(new SFunction[]{AllowSaleList::getProductCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newLinkedList();
        }
        return list.stream().map(AllowSaleList::getProductCode).collect(Collectors.toList());
    }

    @Deprecated
    public List<AllowSaleList> findByBusinessCodesAndListTypeAndRuleType(List<String> businessCodes, String listType, String ruleType) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AllowSaleList::getListType, (Object)listType)).in(AllowSaleList::getBusinessCode, businessCodes)).select(new SFunction[]{AllowSaleList::getProductCode, AllowSaleList::getBusinessCode}).list();
    }

    public Set<String> findBusinessCodesByListTypeAndRuleType(String listType, String ruleType) {
        ruleType = StringUtils.isBlank((CharSequence)ruleType) || AllowSaleRuleTypeEnums.ALLOW.getDictCode().equals(ruleType) ? AllowSaleRuleTypeEnums.ALLOW.getDictCode() : AllowSaleRuleTypeEnums.NOT_ALLOW.getDictCode();
        return ((AllowSaleListMapper)this.baseMapper).findBusinessCodesByListTypeAndRuleType(listType, ruleType);
    }

    public void updateByAllowRule(String ruleCode, Integer offset) {
        ((AllowSaleListMapper)this.baseMapper).updateByAllowRule(ruleCode, offset, TenantUtils.getTenantCode());
    }

    public void updateByNotAllowRule(String ruleCode, Integer offset) {
        ((AllowSaleListMapper)this.baseMapper).updateByNotAllowRule(ruleCode, offset, TenantUtils.getTenantCode());
    }

    public Set<String> findExistsKeys(Set<String> itemKeys) {
        HashSet set = Sets.newHashSet();
        for (List item : Lists.partition((List)Lists.newArrayList(itemKeys), (int)SIZE)) {
            Set<String> existsKeys = ((AllowSaleListMapper)this.baseMapper).findExistsKeys(Sets.newHashSet((Iterable)item), TenantUtils.getTenantCode());
            if (CollectionUtils.isEmpty(existsKeys)) continue;
            set.addAll(existsKeys);
        }
        return set;
    }

    public void cleanListData() {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(AllowSaleList::getAllow, (Object)0)).eq(AllowSaleList::getNotAllow, (Object)0);
        ((AllowSaleListMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
    }

    public void deleteByItemKeys(Set<String> itemKeys) {
        String tenantCode = TenantUtils.getTenantCode();
        for (List list : Lists.partition((List)Lists.newArrayList(itemKeys), (int)SIZE)) {
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(AllowSaleList::getTenantCode, (Object)tenantCode);
            lambdaQuery.in(AllowSaleList::getItemKey, (Collection)list);
            ((AllowSaleListMapper)this.baseMapper).delete((Wrapper)lambdaQuery);
        }
    }
}

