/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import com.biz.crm.dms.business.allow.sale.local.list.repository.AllowSaleListRepository;
import com.biz.crm.dms.business.allow.sale.local.list.repository.AllowSaleRuleRelateListRepository;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import com.biz.crm.dms.business.allow.sale.local.util.AllowSaleUtil;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="allowSaleListService")
public class AllowSaleListServiceImpl
implements AllowSaleListService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleListServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleListRepository allowSaleListRepository;
    @Autowired(required=false)
    private AllowSaleRuleRelateListRepository allowSaleRuleRelateListRepository;

    @Override
    public Page<AllowSaleList> findByConditions(Pageable pageable, AllowSaleListPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AllowSaleListPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isBlank((CharSequence)dto.getRuleType()) || AllowSaleRuleTypeEnums.ALLOW.getDictCode().equals(dto.getRuleType())) {
            dto.setRuleType(AllowSaleRuleTypeEnums.ALLOW.getDictCode());
        } else {
            dto.setRuleType(AllowSaleRuleTypeEnums.NOT_ALLOW.getDictCode());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.allowSaleListRepository.findByConditions((Page<AllowSaleList>)page, dto);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.allowSaleListRepository.deleteByIds(ids);
    }

    @Override
    public List<String> findAllowSaleProductCodes(ValidateAllowSaleProductDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getListType()) || StringUtils.isBlank((CharSequence)dto.getBusinessCode())) {
            return Lists.newLinkedList();
        }
        return this.allowSaleListRepository.findAllowSaleProductCodes(dto);
    }

    @Override
    @Transactional
    public void createByItemKeys(Set<String> itemKeys) {
        if (CollectionUtils.isEmpty(itemKeys)) {
            return;
        }
        this.allowSaleListRepository.deleteByItemKeys(itemKeys);
        List<AllowSaleRuleRelateList> itemData = this.allowSaleRuleRelateListRepository.findByItemKeys(itemKeys);
        if (CollectionUtils.isEmpty(itemData)) {
            return;
        }
        Map<String, List<AllowSaleRuleRelateList>> map = itemData.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getItemKey())).collect(Collectors.groupingBy(AllowSaleRuleRelateList::getItemKey));
        LinkedList addDataList = Lists.newLinkedList();
        for (Map.Entry<String, List<AllowSaleRuleRelateList>> item : map.entrySet()) {
            String itemKey = item.getKey();
            AllowSaleList cur = AllowSaleUtil.findByItemKey(itemKey);
            Map<String, Long> curMap = item.getValue().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleType())).collect(Collectors.groupingBy(AllowSaleRuleRelateList::getRuleType, Collectors.counting()));
            Integer allow = curMap.getOrDefault(AllowSaleRuleTypeEnums.ALLOW.getDictCode(), 0L).intValue();
            Integer notAllow = curMap.getOrDefault(AllowSaleRuleTypeEnums.NOT_ALLOW.getDictCode(), 0L).intValue();
            if (Objects.isNull((Object)cur) || allow == 0 && notAllow == 0) continue;
            cur.setTenantCode(TenantUtils.getTenantCode());
            cur.setItemKey(itemKey);
            cur.setAllow(allow);
            cur.setNotAllow(notAllow);
            addDataList.add(cur);
        }
        if (CollectionUtils.isEmpty((Collection)addDataList)) {
            return;
        }
        this.allowSaleListRepository.saveBatch(addDataList);
    }

    @Override
    @Transactional
    public void createByRule(RelateRule rule, List<AllowSaleList> list) {
        this.updateAllowNumByRule(rule, 1);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (AllowSaleList item : list) {
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        List<AllowSaleList> data = list.stream().distinct().collect(Collectors.toList());
        this.saveByList(data);
    }

    @Override
    @Transactional
    public void saveByList(List<AllowSaleList> saleList) {
        if (CollectionUtils.isEmpty(saleList)) {
            return;
        }
        Set<String> allItemKeys = saleList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getItemKey())).map(AllowSaleList::getItemKey).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(allItemKeys)) {
            return;
        }
        Set<String> addKeys = this.findAddItemKeys(allItemKeys);
        if (CollectionUtils.isEmpty(addKeys)) {
            return;
        }
        List<AllowSaleList> addList = saleList.stream().filter(a -> addKeys.contains(a.getItemKey())).collect(Collectors.toList());
        this.createItemsByList(addList);
    }

    @Override
    @Transactional
    public void updateAllowNumByRule(RelateRule rule, Integer offset) {
        Validate.isTrue((Objects.nonNull(rule) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getRuleCode(), rule.getRuleType()}) ? 1 : 0) != 0, (String)"\u89c4\u5219\u7f16\u7801\u3001\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (AllowSaleRuleTypeEnums.ALLOW.getDictCode().equals(rule.getRuleType())) {
            this.allowSaleListRepository.updateByAllowRule(rule.getRuleCode(), offset);
        } else if (AllowSaleRuleTypeEnums.NOT_ALLOW.getDictCode().equals(rule.getRuleType())) {
            this.allowSaleListRepository.updateByNotAllowRule(rule.getRuleCode(), offset);
        }
        this.cleanListData();
    }

    @Override
    @Transactional
    public void cleanListData() {
        this.allowSaleListRepository.cleanListData();
    }

    private void createItemsByList(List<AllowSaleList> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set<String> itemKeys = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getItemKey())).map(AllowSaleList::getItemKey).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(itemKeys)) {
            return;
        }
        List<AllowSaleRuleRelateList> data = this.allowSaleRuleRelateListRepository.findByItemKeys(itemKeys);
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Map<String, List<AllowSaleRuleRelateList>> map = data.stream().collect(Collectors.groupingBy(AllowSaleRuleRelateList::getItemKey));
        LinkedList addList = Lists.newLinkedList();
        for (AllowSaleList item : list) {
            List<AllowSaleRuleRelateList> curList = map.get(item.getItemKey());
            if (CollectionUtils.isEmpty(curList)) continue;
            Map<String, Long> mapNum = curList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleType())).collect(Collectors.groupingBy(AllowSaleRuleRelateList::getRuleType, Collectors.counting()));
            Integer allow = mapNum.getOrDefault(AllowSaleRuleTypeEnums.ALLOW.getDictCode(), 0L).intValue();
            Integer notAllow = mapNum.getOrDefault(AllowSaleRuleTypeEnums.NOT_ALLOW.getDictCode(), 0L).intValue();
            item.setAllow(allow);
            item.setNotAllow(notAllow);
            addList.add(item);
        }
        if (CollectionUtils.isEmpty((Collection)addList)) {
            return;
        }
        this.allowSaleListRepository.saveBatch(addList);
    }

    private Set<String> findAddItemKeys(Set<String> itemKeys) {
        if (CollectionUtils.isEmpty(itemKeys)) {
            return Sets.newHashSet();
        }
        Set<String> existsKeys = this.allowSaleListRepository.findExistsKeys(itemKeys);
        existsKeys = Optional.ofNullable(existsKeys).orElse(Sets.newHashSet());
        return Sets.newHashSet((Iterable)Sets.difference(itemKeys, existsKeys));
    }
}

