/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AllowSaleListVoServiceImpl
implements AllowSaleListVoService {
    @Autowired(required=false)
    private AllowSaleListService allowSaleListService;

    public List<String> findAllowSaleProductCodes(ValidateAllowSaleProductDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getListType()) || StringUtils.isBlank((CharSequence)dto.getBusinessCode())) {
            return Lists.newLinkedList();
        }
        List<String> list = this.allowSaleListService.findAllowSaleProductCodes(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        HashSet productCodes = Sets.newHashSet(list);
        if (CollectionUtils.isEmpty((Collection)productCodes)) {
            return Lists.newLinkedList();
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getProductCodeList())) {
            HashSet set = Sets.newHashSet((Iterable)dto.getProductCodeList());
            Sets.SetView difference = Sets.intersection((Set)productCodes, (Set)set);
            if (difference.isEmpty()) {
                return Lists.newLinkedList();
            }
            return Lists.newArrayList((Iterable)difference);
        }
        return Lists.newArrayList((Iterable)productCodes);
    }
}

