/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import com.biz.crm.dms.business.allow.sale.local.list.repository.AllowSaleRuleRelateListRepository;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleRuleRelateListService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="allowSaleDetailRelateRuleService")
public class AllowSaleRuleRelateListServiceImpl
implements AllowSaleRuleRelateListService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleRuleRelateListServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleRelateListRepository allowSaleRuleRelateListRepository;
    @Autowired(required=false)
    private AllowSaleListService allowSaleListService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void createByRule(RelateRule rule, List<AllowSaleRuleRelateList> list) {
        boolean f = Objects.nonNull(rule) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getRuleCode(), rule.getRuleType(), rule.getListType()});
        Validate.isTrue((boolean)f, (String)"\u89c4\u5219\u7f16\u7801\u3001\u89c4\u5219\u7c7b\u578b\u3001\u6e05\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.deleteByRule(rule);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (AllowSaleRuleRelateList item : list) {
            item.setRuleCode(rule.getRuleCode());
            item.setRuleType(rule.getRuleType());
            item.setListType(rule.getListType());
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        List<AllowSaleRuleRelateList> data = this.distinctData(list);
        this.allowSaleRuleRelateListRepository.saveBatch(data);
        List saleList = (List)this.nebulaToolkitService.copyCollectionByBlankList(data, AllowSaleRuleRelateList.class, AllowSaleList.class, HashSet.class, ArrayList.class, new String[0]);
        this.allowSaleListService.createByRule(rule, saleList);
    }

    @Override
    @Transactional
    public void deleteByRule(RelateRule rule) {
        Validate.isTrue((Objects.nonNull(rule) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rule.getRuleCode(), rule.getRuleType()}) ? 1 : 0) != 0, (String)"\u89c4\u5219\u7f16\u7801\u53ca\u89c4\u5219\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.allowSaleListService.updateAllowNumByRule(rule, -1);
        this.allowSaleRuleRelateListRepository.deleteByRuleCode(rule.getRuleCode());
    }

    @Override
    @Transactional
    public void createByList(List<AllowSaleRuleRelateList> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (AllowSaleRuleRelateList item : list) {
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        List<AllowSaleRuleRelateList> data = this.distinctData(list);
        Set<String> itemKeys = data.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getItemKey())).map(AllowSaleRuleRelateList::getItemKey).collect(Collectors.toSet());
        Set<String> subItemKeys = data.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSubItemKey())).map(AllowSaleRuleRelateList::getSubItemKey).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(subItemKeys) || CollectionUtils.isEmpty(itemKeys)) {
            return;
        }
        this.allowSaleRuleRelateListRepository.deleteBySubItemKeys(subItemKeys);
        this.allowSaleRuleRelateListRepository.saveBatch(data);
        this.allowSaleListService.createByItemKeys(itemKeys);
    }

    @Override
    @Transactional
    public void deleteByList(List<AllowSaleRuleRelateList> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (AllowSaleRuleRelateList item : list) {
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        List<AllowSaleRuleRelateList> data = this.distinctData(list);
        Set<String> subItemKeys = data.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSubItemKey())).map(AllowSaleRuleRelateList::getSubItemKey).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(subItemKeys)) {
            this.allowSaleRuleRelateListRepository.deleteBySubItemKeys(subItemKeys);
        }
        Set<String> itemKeys = data.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getItemKey())).map(AllowSaleRuleRelateList::getItemKey).collect(Collectors.toSet());
        this.allowSaleListService.createByItemKeys(itemKeys);
    }

    private List<AllowSaleRuleRelateList> distinctData(List<AllowSaleRuleRelateList> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return list.stream().distinct().collect(Collectors.toList());
    }
}

