/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleBusinessTrigger;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerRelateOrgEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerRelateOrgEventListener;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AllowCustomerRelateOrgEventListenerImpl
implements CustomerRelateOrgEventListener {
    @Autowired(required=false)
    private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

    @Transactional
    public void onRebind(CustomerRelateOrgEventDto dto) {
        ArrayList orgList;
        CustomerRelateOrgVo cur;
        Validate.notNull((Object)dto, (String)"\u7ecf\u9500\u5546\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerVo vo = dto.getCustomerVo();
        Validate.notNull((Object)dto, (String)"\u7ecf\u9500\u5546\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String oldOrgCode = Optional.ofNullable(dto.getOldOrgCode()).orElse("");
        String orgCode = Optional.ofNullable(dto.getNewOrgCode()).orElse("");
        if (!ProcessStatusEnum.PASS.getDictCode().equals(vo.getProcessStatus()) || oldOrgCode.equals(orgCode)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)oldOrgCode)) {
            cur = new CustomerRelateOrgVo();
            cur.setOrgCode(oldOrgCode);
            orgList = Lists.newArrayList((Object[])new CustomerRelateOrgVo[]{cur});
            vo.setOrgList((List)orgList);
            this.handlerAllowSale(vo, Boolean.FALSE);
        }
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            cur = new CustomerRelateOrgVo();
            cur.setOrgCode(orgCode);
            orgList = Lists.newArrayList((Object[])new CustomerRelateOrgVo[]{cur});
            vo.setOrgList((List)orgList);
            this.handlerAllowSale(vo, Boolean.TRUE);
        }
    }

    private void handlerAllowSale(CustomerVo vo, Boolean createFlag) {
        if (Objects.isNull(vo) || StringUtils.isBlank((CharSequence)vo.getCustomerCode())) {
            return;
        }
        String customerCode = vo.getCustomerCode();
        List orgList = vo.getOrgList();
        Set<Object> orgCodeSet = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            orgCodeSet = orgList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(CustomerRelateOrgVo::getOrgCode).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty((Collection)orgCodeSet)) {
            AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
            business.setBusinessCode(customerCode);
            business.setDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER.getCode());
            if (Boolean.TRUE.equals(createFlag)) {
                this.allowSaleRuleListAdapter.createByBusiness(business);
            } else {
                this.allowSaleRuleListAdapter.deleteByBusiness(business);
            }
        } else {
            for (String orgCode : orgCodeSet) {
                AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
                business.setBusinessCode(customerCode);
                business.setDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER.getCode());
                business.setRelateTypeCode(orgCode);
                business.setRelateDimensionType(AllowSaleDimensionTypeEnums.CUSTOMER_ORG.getCode());
                if (Boolean.TRUE.equals(createFlag)) {
                    this.allowSaleRuleListAdapter.createByBusiness(business);
                    continue;
                }
                this.allowSaleRuleListAdapter.deleteByBusiness(business);
            }
        }
    }
}

