/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleRuleRelateList;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleRuleRelateListService;
import com.biz.crm.dms.business.allow.sale.local.product.service.AllowSaleRuleProductService;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.service.AllowSaleRuleService;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AllowOrgEventListenerImpl
implements OrgEventListener {
    @Autowired(required=false)
    private DimensionService dimensionService;
    @Autowired(required=false)
    private AllowSaleRuleProductService allowSaleRuleProductService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private AllowSaleRuleService allowSaleRuleService;
    @Autowired(required=false)
    private AllowSaleRuleRelateListService allowSaleRuleRelateListService;

    public void onDelete(List<String> orgCodes) {
    }

    public void onDeleteBatch(OrgEventBatchDto orgEventBatchDto) {
    }

    public void onEnableBatch(OrgEventBatchDto orgEventBatchDto) {
    }

    public void onDisableBatch(OrgEventBatchDto orgEventBatchDto) {
    }

    @Transactional
    public void onUpdate(OrgEventDto dto) {
        if (Objects.isNull(dto) || dto.getParentCode().equals(dto.getOldParentCode()) || StringUtils.isBlank((CharSequence)dto.getOrgCode())) {
            return;
        }
        HashSet set = Sets.newHashSet((Object[])new String[]{AllowSaleDimensionTypeEnums.CUSTOMER_ORG.getCode(), AllowSaleDimensionTypeEnums.TERMINAL_ORG.getCode()});
        for (String item : set) {
            this.onItemUpdate(dto, item);
        }
    }

    private void onItemUpdate(OrgEventDto dto, String dimensionType) {
        Map map1;
        Map<String, Set<String>> map;
        Set<Object> oldAllowRuleCodes = Sets.newHashSet();
        Set<Object> allowRuleCodes = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)dto.getOldParentCode())) {
            map = this.dimensionService.findRelateRuleCodesMapByRelateCodes(Lists.newArrayList((Object[])new String[]{dto.getOldParentCode()}), dimensionType);
            oldAllowRuleCodes = map.getOrDefault(dto.getOldParentCode(), Sets.newHashSet());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentCode())) {
            map = this.dimensionService.findRelateRuleCodesMapByRelateCodes(Lists.newArrayList((Object[])new String[]{dto.getParentCode()}), dimensionType);
            allowRuleCodes = map.getOrDefault(dto.getParentCode(), Sets.newHashSet());
        }
        HashSet delRuleCodeSet = Sets.newHashSet((Iterable)Sets.difference((Set)oldAllowRuleCodes, (Set)allowRuleCodes));
        HashSet addRuleCodeSet = Sets.newHashSet((Iterable)Sets.difference((Set)allowRuleCodes, (Set)oldAllowRuleCodes));
        HashSet allRuleCodeSet = Sets.newHashSet();
        allRuleCodeSet.addAll(addRuleCodeSet);
        allRuleCodeSet.addAll(delRuleCodeSet);
        if (CollectionUtils.isEmpty((Collection)allRuleCodeSet)) {
            return;
        }
        List<AllowSaleRule> ruleList = this.allowSaleRuleService.findByCodesAndTenantCode(Lists.newArrayList((Iterable)allRuleCodeSet), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        Map<String, AllowSaleRule> mapRule = ruleList.stream().filter(a -> DelFlagStatusEnum.NORMAL.getCode().equals(a.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(a.getEnableStatus())).collect(Collectors.toMap(AllowSaleRule::getRuleCode, Function.identity(), (a, b) -> a));
        HashSet businessCodeSet = Sets.newHashSet();
        String orgCode = dto.getOrgCode();
        if (dimensionType.equals(AllowSaleDimensionTypeEnums.CUSTOMER_ORG.getCode())) {
            Map map12 = this.customerVoService.findAllowSaleCustomerByOrgCodes((Set)Sets.newHashSet((Object[])new String[]{orgCode}));
            if (!map12.isEmpty()) {
                businessCodeSet.addAll(map12.keySet());
            }
        } else if (dimensionType.equals(AllowSaleDimensionTypeEnums.TERMINAL_ORG.getCode()) && !(map1 = this.terminalVoService.findAllowSaleTerminalByOrgCodes((Set)Sets.newHashSet((Object[])new String[]{orgCode}))).isEmpty()) {
            businessCodeSet.addAll(map1.keySet());
        }
        if (CollectionUtils.isEmpty((Collection)businessCodeSet)) {
            return;
        }
        this.handlerAllowSaleList(delRuleCodeSet, addRuleCodeSet, mapRule, businessCodeSet);
    }

    private void handlerAllowSaleList(Set<String> delRuleCodeSet, Set<String> addRuleCodeSet, Map<String, AllowSaleRule> mapRule, Set<String> businessCodeSet) {
        if (mapRule.isEmpty() || CollectionUtils.isEmpty(businessCodeSet)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        for (Map.Entry<String, AllowSaleRule> item : mapRule.entrySet()) {
            String ruleCode = item.getKey();
            AllowSaleRule rule = item.getValue();
            List<AllowSaleRuleRelateList> list = this.findItemRelateList(rule, businessCodeSet, tenantCode);
            if (CollectionUtils.isEmpty(list)) continue;
            if (delRuleCodeSet.contains(ruleCode)) {
                this.allowSaleRuleRelateListService.deleteByList(list);
                continue;
            }
            if (!addRuleCodeSet.contains(ruleCode)) continue;
            this.allowSaleRuleRelateListService.createByList(list);
        }
    }

    private List<AllowSaleRuleRelateList> findItemRelateList(AllowSaleRule rule, Set<String> businessCodeSet, String tenantCode) {
        Map<String, Set<String>> productCodeSetMap = this.allowSaleRuleProductService.findRuleRelateProductCodesMapByRuleCodes(Lists.newArrayList((Object[])new String[]{rule.getRuleCode()}));
        if (productCodeSetMap.isEmpty()) {
            return Lists.newLinkedList();
        }
        Set<String> productCodeSet = productCodeSetMap.getOrDefault(rule.getRuleCode(), Sets.newHashSet());
        String listType = this.dimensionService.getListType(rule.getDimensionType());
        ArrayList list = Lists.newArrayList();
        for (String businessCode : businessCodeSet) {
            for (String productCode : productCodeSet) {
                AllowSaleRuleRelateList cur = new AllowSaleRuleRelateList();
                cur.setTenantCode(tenantCode);
                cur.setRuleType(rule.getRuleType());
                cur.setRuleCode(rule.getRuleCode());
                cur.setBusinessCode(businessCode);
                cur.setProductCode(productCode);
                cur.setListType(listType);
                cur.setItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                cur.setSubItemKey(StringUtils.joinWith((String)":", (Object[])new Object[]{cur.getRuleCode(), cur.getListType(), cur.getBusinessCode(), cur.getProductCode()}));
                RelateRule relateRule = new RelateRule();
                relateRule.setRuleType(cur.getRuleType());
                relateRule.setRuleCode(cur.getRuleCode());
                relateRule.setListType(cur.getListType());
                cur.setRule(relateRule);
                list.add(cur);
            }
        }
        return list;
    }
}

