/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleProductTrigger;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.mdm.business.product.sdk.dto.ProductEventDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductSingleEventDto;
import com.biz.crm.mdm.business.product.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.sdk.event.ProductEventListener;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AllowProductEventListenerImpl
implements ProductEventListener {
    @Autowired(required=false)
    private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

    @Transactional
    public void onCreate(ProductEventDto productEventDto) {
        ProductVo productVo = productEventDto.getNewest();
        Validate.notNull((Object)productVo, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (EnableStatusEnum.DISABLE.getCode().equals(productVo.getEnableStatus()) || IsShelfEnum.DOWN.getCode().equals(productVo.getIsShelf())) {
            return;
        }
        this.handlerAllowSale(productVo.getProductCode(), productVo.getProductLevelCode(), Boolean.TRUE);
    }

    @Transactional
    public void onUpdate(ProductEventDto productEventDto) {
        ProductVo newest = productEventDto.getNewest();
        ProductVo original = productEventDto.getOriginal();
        Validate.notNull((Object)newest, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)original, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (newest.getEnableStatus().equals(original.getEnableStatus()) && newest.getIsShelf().equals(original.getIsShelf()) && newest.getProductLevelCode().equals(original.getProductCode())) {
            return;
        }
        String productCode = original.getProductCode();
        this.handlerAllowSale(productCode, original.getProductLevelCode(), Boolean.FALSE);
        this.handlerAllowSale(productCode, newest.getProductLevelCode(), Boolean.TRUE);
    }

    @Transactional
    public void onDelete(ProductEventDto productEventDto) {
        ProductVo original = productEventDto.getOriginal();
        Validate.notNull((Object)original, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (EnableStatusEnum.DISABLE.getCode().equals(original.getEnableStatus()) || IsShelfEnum.DOWN.getCode().equals(original.getIsShelf())) {
            return;
        }
        this.handlerAllowSale(original.getProductCode(), original.getProductLevelCode(), Boolean.FALSE);
    }

    @Transactional
    public void onEnable(ProductSingleEventDto productSingleEventDto) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)productSingleEventDto.getNewest());
        Validate.notNull((Object)o, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object productCode = o.get((Object)"productCode");
        Validate.notNull((Object)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object isShelf = o.get((Object)"isShelf");
        Validate.notNull((Object)isShelf, (String)"\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (IsShelfEnum.DOWN.getCode().equals(isShelf.toString())) {
            return;
        }
        String productLevelCode = Optional.ofNullable(o.get((Object)"productLevelCode")).orElse("").toString();
        this.handlerAllowSale(productCode.toString(), productLevelCode, Boolean.TRUE);
    }

    @Transactional
    public void onDisable(ProductSingleEventDto productSingleEventDto) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)productSingleEventDto.getNewest());
        Validate.notNull((Object)o, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object productCode = o.get((Object)"productCode");
        Validate.notNull((Object)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object isShelf = o.get((Object)"isShelf");
        Validate.notNull((Object)isShelf, (String)"\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String productLevelCode = Optional.ofNullable(o.get((Object)"productLevelCode")).orElse("").toString();
        if (IsShelfEnum.DOWN.getCode().equals(isShelf.toString())) {
            return;
        }
        this.handlerAllowSale(productCode.toString(), productLevelCode, Boolean.FALSE);
    }

    @Transactional
    public void onUpShelf(ProductSingleEventDto productSingleEventDto) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)productSingleEventDto.getNewest());
        Validate.notNull((Object)o, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object productCode = o.get((Object)"productCode");
        Validate.notNull((Object)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String productLevelCode = Optional.ofNullable(o.get((Object)"productLevelCode")).orElse("").toString();
        Object enableStatus = o.get((Object)"enableStatus");
        Validate.notNull((Object)enableStatus, (String)"\u5546\u54c1\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (EnableStatusEnum.DISABLE.getCode().equals(enableStatus.toString())) {
            return;
        }
        this.handlerAllowSale(productCode.toString(), productLevelCode, Boolean.TRUE);
    }

    @Transactional
    public void onDownShelf(ProductSingleEventDto productSingleEventDto) {
        JSONObject o = (JSONObject)JSON.toJSON((Object)productSingleEventDto.getNewest());
        Validate.notNull((Object)o, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object productCode = o.get((Object)"productCode");
        Validate.notNull((Object)productCode, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String productLevelCode = Optional.ofNullable(o.get((Object)"productLevelCode")).orElse("").toString();
        Object enableStatus = o.get((Object)"enableStatus");
        Validate.notNull((Object)enableStatus, (String)"\u5546\u54c1\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (EnableStatusEnum.DISABLE.getCode().equals(enableStatus.toString())) {
            return;
        }
        this.handlerAllowSale(productCode.toString(), productLevelCode, Boolean.FALSE);
    }

    private void handlerAllowSale(String productCode, String productLevelCode, Boolean createFlag) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return;
        }
        AllowSaleRuleProductTrigger product = new AllowSaleRuleProductTrigger();
        product.setProductCode(productCode);
        product.setProductLevelCode(productLevelCode);
        if (Boolean.TRUE.equals(createFlag)) {
            this.allowSaleRuleListAdapter.createByProduct(product);
        } else {
            this.allowSaleRuleListAdapter.deleteByProduct(product);
        }
    }
}

