/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.rule.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.service.AllowSaleRuleService;
import com.biz.crm.dms.business.allow.sale.sdk.rule.dto.AllowSaleRulePaginationDto;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5141\u9500\u89c4\u5219\u4e3b\u7ec6\u4fe1\u606f: AllowSaleRule: \u5141\u9500\u89c4\u5219\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/allowSaleRule/allowSaleRule"})
public class AllowSaleRuleController {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleRuleController.class);
    @Autowired(required=false)
    private AllowSaleRuleService allowSaleRuleService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<AllowSaleRule>> findByConditions(@PageableDefault(value=50) Pageable pageable, AllowSaleRulePaginationDto paginationDto) {
        try {
            Page<AllowSaleRule> result = this.allowSaleRuleService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<AllowSaleRule> findDetailById(@RequestParam(value="id") String id) {
        try {
            AllowSaleRule allowSaleRule = this.allowSaleRuleService.findDetailById(id);
            return Result.ok((Object)((Object)allowSaleRule));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<AllowSaleRule> create(@RequestBody AllowSaleRule allowSaleRule) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            AllowSaleRule current = this.allowSaleRuleService.create(allowSaleRule);
            Result result = Result.ok((Object)((Object)current));
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<AllowSaleRule> update(@RequestBody AllowSaleRule allowSaleRule) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            AllowSaleRule current = this.allowSaleRuleService.update(allowSaleRule);
            Result result = Result.ok((Object)((Object)current));
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            this.allowSaleRuleService.updateDelFlagByIds(ids);
            Result result = Result.ok((String)"\u5220\u9664\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            this.allowSaleRuleService.enableBatch(ids);
            Result result = Result.ok((String)"\u542f\u7528\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        Validate.isTrue((boolean)this.redisMutexService.tryLock("crm:dms:lock:rule-lock", TimeUnit.SECONDS, 5), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u89c4\u5219\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        try {
            this.allowSaleRuleService.disableBatch(ids);
            Result result = Result.ok((String)"\u7981\u7528\u6210\u529f");
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock("crm:dms:lock:rule-lock");
        }
    }
}

