/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.allow.sale.local.rule.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import com.biz.crm.dms.business.allow.sale.local.product.service.AllowSaleRuleProductService;
import com.biz.crm.dms.business.allow.sale.local.rule.entity.AllowSaleRule;
import com.biz.crm.dms.business.allow.sale.local.rule.repository.AllowSaleRuleRepository;
import com.biz.crm.dms.business.allow.sale.local.rule.service.AllowSaleRuleService;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.dms.business.allow.sale.sdk.config.AllowSaleProperties;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleCreateTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleProductRelateTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleRuleTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.rule.dto.AllowSaleRulePaginationDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="allowSaleRuleService")
public class AllowSaleRuleServiceImpl
implements AllowSaleRuleService {
    private static final Logger log = LoggerFactory.getLogger(AllowSaleRuleServiceImpl.class);
    @Autowired(required=false)
    private AllowSaleRuleRepository allowSaleRuleRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private AllowSaleRuleProductService allowSaleRuleProductService;
    @Autowired(required=false)
    private DimensionService dimensionService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private ProductSpuVoService productSpuVoService;
    @Autowired(required=false)
    private AllowSaleProperties allowSaleProperties;
    @Autowired(required=false)
    private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

    @Override
    public Page<AllowSaleRule> findByConditions(Pageable pageable, AllowSaleRulePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AllowSaleRulePaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AllowSaleRule> pageResult = this.allowSaleRuleRepository.findByConditions((Page<AllowSaleRule>)page, dto);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            for (AllowSaleRule item : pageResult.getRecords()) {
                item.setFlag(this.allowSaleProperties.checkByCreateType(item.getCreateType()));
            }
        }
        return pageResult;
    }

    @Override
    public AllowSaleRule findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AllowSaleRule re = this.allowSaleRuleRepository.findById(id);
        if (Objects.isNull((Object)re)) {
            return null;
        }
        JSONObject jsonObject = this.dimensionService.findByRuleCode(re.getRuleCode(), re.getDimensionType());
        List<AllowSaleRuleProduct> ruleProductList = this.allowSaleRuleProductService.findByRuleCode(re.getRuleCode());
        this.setAllowSaleRuleProductList(ruleProductList);
        re.setDimensionJson(jsonObject);
        re.setProductList(ruleProductList);
        return re;
    }

    @Override
    @Transactional
    public AllowSaleRule create(AllowSaleRule allowSaleRule) {
        this.createValidation(allowSaleRule);
        allowSaleRule.setTenantCode(TenantUtils.getTenantCode());
        allowSaleRule.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isBlank((CharSequence)allowSaleRule.getCreateType())) {
            allowSaleRule.setCreateType(AllowSaleRuleCreateTypeEnums.DEFAULT.getCode());
        }
        if (StringUtils.isBlank((CharSequence)allowSaleRule.getEnableStatus())) {
            allowSaleRule.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isBlank((CharSequence)allowSaleRule.getRuleCode())) {
            allowSaleRule.setRuleCode((String)this.generateCodeService.generateCode("YX", 1).get(0));
        } else {
            Integer count = this.allowSaleRuleRepository.countByRuleCode(allowSaleRule.getRuleCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(allowSaleRule.getRuleCode() + "\u7f16\u7801\u5df2\u5b58\u5728(\u5df2\u903b\u8f91\u5220\u9664)"), (Object[])new Object[0]);
        }
        this.allowSaleRuleRepository.saveOrUpdate((Object)allowSaleRule);
        this.bindExtInfo(allowSaleRule);
        if (EnableStatusEnum.ENABLE.getCode().equals(allowSaleRule.getEnableStatus())) {
            this.allowSaleRuleListAdapter.createByRule(allowSaleRule);
        }
        return allowSaleRule;
    }

    @Override
    @Transactional
    public AllowSaleRule update(AllowSaleRule allowSaleRule) {
        this.updateValidation(allowSaleRule);
        Validate.isTrue((boolean)AllowSaleRuleCreateTypeEnums.DEFAULT.getCode().equals(allowSaleRule.getCreateType()), (String)"\u5f53\u524d\u89c4\u5219\u5173\u8054\u5408\u540c\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        String currentId = allowSaleRule.getId();
        AllowSaleRule current = this.allowSaleRuleRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)allowSaleRule.getRuleCode().equals(current.getRuleCode()), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.allowSaleRuleRepository.saveOrUpdate((Object)allowSaleRule);
        this.bindExtInfo(allowSaleRule);
        if (EnableStatusEnum.ENABLE.getCode().equals(allowSaleRule.getEnableStatus())) {
            this.allowSaleRuleListAdapter.createByRule(allowSaleRule);
        }
        return allowSaleRule;
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AllowSaleRule> list = this.allowSaleRuleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<AllowSaleRule> first = list.stream().filter(a -> !AllowSaleRuleCreateTypeEnums.DEFAULT.getCode().equals(a.getCreateType())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5b58\u5728\u975e\u624b\u52a8\u521b\u5efa\u7684\u89c4\u5219\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        this.allowSaleRuleRepository.updateDelFlagByIds(ids);
        for (AllowSaleRule item : list) {
            this.allowSaleRuleListAdapter.deleteByRule(item);
        }
    }

    @Override
    public List<AllowSaleRule> findByCodesAndTenantCode(List<String> ruleCodeList, String tenantCode) {
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Lists.newLinkedList();
        }
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            tenantCode = TenantUtils.getTenantCode();
        }
        return this.allowSaleRuleRepository.findByCodesAndTenantCode(ruleCodeList, tenantCode);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AllowSaleRule> list = this.allowSaleRuleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<AllowSaleRule> first = list.stream().filter(a -> !AllowSaleRuleCreateTypeEnums.DEFAULT.getCode().equals(a.getCreateType())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5b58\u5728\u975e\u624b\u52a8\u521b\u5efa\u7684\u89c4\u5219\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        List list1 = list.stream().filter(a -> EnableStatusEnum.DISABLE.getCode().equals(a.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list1)) {
            return;
        }
        Set set = list1.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.allowSaleRuleRepository.updateEnableStatusByIds(Lists.newArrayList(set), EnableStatusEnum.ENABLE);
        for (AllowSaleRule allowSaleRule : list1) {
            JSONObject jsonObject = this.dimensionService.findByRuleCode(allowSaleRule.getRuleCode(), allowSaleRule.getDimensionType());
            List<AllowSaleRuleProduct> ruleProductList = this.allowSaleRuleProductService.findByRuleCode(allowSaleRule.getRuleCode());
            allowSaleRule.setProductList(ruleProductList);
            allowSaleRule.setDimensionJson(jsonObject);
            this.allowSaleRuleListAdapter.createByRule(allowSaleRule);
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AllowSaleRule> list = this.allowSaleRuleRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<AllowSaleRule> first = list.stream().filter(a -> !AllowSaleRuleCreateTypeEnums.DEFAULT.getCode().equals(a.getCreateType())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5b58\u5728\u975e\u624b\u52a8\u521b\u5efa\u7684\u89c4\u5219\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!", (Object[])new Object[0]);
        List list1 = list.stream().filter(a -> EnableStatusEnum.ENABLE.getCode().equals(a.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list1)) {
            return;
        }
        Set set = list1.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.allowSaleRuleRepository.updateEnableStatusByIds(Lists.newArrayList(set), EnableStatusEnum.DISABLE);
        for (AllowSaleRule item : list) {
            this.allowSaleRuleListAdapter.deleteByRule(item);
        }
    }

    @Override
    @Transactional
    public void updateByContractCodesAndEnableStatus(List<String> contractCodes, String enableStatus) {
        block7: {
            List saleRuleList;
            block6: {
                if (CollectionUtils.isEmpty(contractCodes) || StringUtils.isBlank((CharSequence)enableStatus)) {
                    return;
                }
                List<AllowSaleRule> list = this.allowSaleRuleRepository.findByRelateCodesAndCreateType(contractCodes, AllowSaleRuleCreateTypeEnums.CONTRACT.getCode());
                if (CollectionUtils.isEmpty(list)) {
                    return;
                }
                saleRuleList = list.stream().filter(a -> !a.getEnableStatus().equals(enableStatus)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(saleRuleList)) {
                    return;
                }
                for (AllowSaleRule allowSaleRule : saleRuleList) {
                    allowSaleRule.setEnableStatus(enableStatus);
                }
                this.allowSaleRuleRepository.saveOrUpdateBatch(saleRuleList);
                if (!enableStatus.equals(EnableStatusEnum.DISABLE.getCode())) break block6;
                for (AllowSaleRule item : saleRuleList) {
                    this.allowSaleRuleListAdapter.deleteByRule(item);
                }
                break block7;
            }
            if (!enableStatus.equals(EnableStatusEnum.ENABLE.getCode())) break block7;
            for (AllowSaleRule allowSaleRule : saleRuleList) {
                JSONObject jsonObject = this.dimensionService.findByRuleCode(allowSaleRule.getRuleCode(), allowSaleRule.getDimensionType());
                List<AllowSaleRuleProduct> ruleProductList = this.allowSaleRuleProductService.findByRuleCode(allowSaleRule.getRuleCode());
                allowSaleRule.setProductList(ruleProductList);
                allowSaleRule.setDimensionJson(jsonObject);
                this.allowSaleRuleListAdapter.createByRule(allowSaleRule);
            }
        }
    }

    @Override
    public List<AllowSaleRule> findByContractCodes(Set<String> contractCodes) {
        if (CollectionUtils.isEmpty(contractCodes)) {
            return Lists.newLinkedList();
        }
        return this.allowSaleRuleRepository.findByContractCodes(contractCodes);
    }

    private void bindExtInfo(AllowSaleRule allowSaleRule) {
        Validate.notNull((Object)((Object)allowSaleRule), (String)"\u5141\u9500\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        allowSaleRule.getDimensionJson().put("ruleCode", (Object)allowSaleRule.getRuleCode());
        this.dimensionService.saveDimension(allowSaleRule.getDimensionJson(), allowSaleRule.getDimensionType());
        if (CollectionUtils.isNotEmpty(allowSaleRule.getProductList())) {
            for (AllowSaleRuleProduct item : allowSaleRule.getProductList()) {
                item.setRuleCode(allowSaleRule.getRuleCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            }
            this.allowSaleRuleProductService.batchSave(allowSaleRule.getProductList());
        }
    }

    private void createValidation(AllowSaleRule allowSaleRule) {
        this.validation(allowSaleRule);
    }

    private void updateValidation(AllowSaleRule allowSaleRule) {
        Validate.notBlank((CharSequence)allowSaleRule.getId(), (String)"\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getRuleCode(), (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)allowSaleRule.getCreateType().equals(AllowSaleRuleCreateTypeEnums.DEFAULT.getCode()), (String)"\u975e\u624b\u52a8\u521b\u5efa\u4fe1\u606f\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        this.validation(allowSaleRule);
    }

    private void validation(AllowSaleRule allowSaleRule) {
        if (StringUtils.isBlank((CharSequence)allowSaleRule.getRuleType())) {
            allowSaleRule.setRuleType(AllowSaleRuleTypeEnums.ALLOW.getDictCode());
        }
        Validate.notBlank((CharSequence)allowSaleRule.getRuleName(), (String)"\u5141\u9500\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getDimensionType(), (String)"\u89c4\u5219\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)allowSaleRule.getCreateType(), (String)"\u521b\u5efa\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)allowSaleRule.getDimensionJson(), (String)"\u7ef4\u5ea6\u89c4\u5219\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(allowSaleRule.getProductList()), (String)"\u53ef\u8d2d\u5546\u54c1\u7ec4\u7ec7\u3001\u7ec8\u7aef\u6216\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void setAllowSaleRuleProductList(List<AllowSaleRuleProduct> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> mapSpu = Maps.newHashMap();
        Map<Object, Object> mapLevel = Maps.newHashMap();
        Map map = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRelateType()) && StringUtils.isNotBlank((CharSequence)a.getRelateCode())).collect(Collectors.groupingBy(AllowSaleRuleProduct::getRelateType, Collectors.mapping(AllowSaleRuleProduct::getRelateCode, Collectors.toList())));
        for (Map.Entry entry : map.entrySet()) {
            List curList;
            if (AllowSaleRuleProductRelateTypeEnums.SPU.getCode().equals(entry.getKey())) {
                curList = this.productSpuVoService.findBySpuCodes(entry.getValue());
                if (!CollectionUtils.isNotEmpty((Collection)curList)) continue;
                mapSpu = curList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getSpuCode(), a.getSpuName()})).collect(Collectors.toMap(ProductSpuVo::getSpuCode, ProductSpuVo::getSpuName, (a, b) -> a));
                continue;
            }
            if (!AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.getCode().equals(entry.getKey()) || !CollectionUtils.isNotEmpty((Collection)(curList = this.productLevelVoSdkService.findListByCodes(entry.getValue())))) continue;
            mapLevel = curList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getProductLevelName()})).collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (a, b) -> a));
        }
        for (AllowSaleRuleProduct allowSaleRuleProduct : list) {
            AllowSaleRuleProductRelateTypeEnums typeEnums = AllowSaleRuleProductRelateTypeEnums.findByCode((String)allowSaleRuleProduct.getRelateType());
            if (Objects.isNull(typeEnums)) {
                return;
            }
            if (AllowSaleRuleProductRelateTypeEnums.SPU.equals((Object)typeEnums)) {
                allowSaleRuleProduct.setRelateName(mapSpu.getOrDefault(allowSaleRuleProduct.getRelateCode(), ""));
                continue;
            }
            if (!AllowSaleRuleProductRelateTypeEnums.PRODUCT_LEVEL.equals((Object)typeEnums)) continue;
            allowSaleRuleProduct.setRelateName(mapLevel.getOrDefault(allowSaleRuleProduct.getRelateCode(), ""));
        }
    }
}

