package com.biz.crm.dms.business.allow.sale.sdk.config;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * crm-dms 允销功能模块配置信息
 *
 * @author sunx
 * @date 2021/11/24
 */
@Component
@ConfigurationProperties(prefix = "crm.dms.allow-sale")
@Getter
@Setter
public class AllowSaleProperties {

  /** 规则可被修改类型集合 */
  private List<String> ruleType;

  /**
   * 判断当前创建类型的规则，是否可以从规则管理界面修改
   *
   * @param createType 创建方式
   * @return
   */
  public Boolean checkByCreateType(String createType) {
    if (StringUtils.isBlank(createType)) {
      return false;
    }
    if (CollectionUtils.isEmpty(ruleType)) {
      return true;
    }
    Set<String> set = Sets.newHashSet(ruleType);
    return set.contains(createType);
  }
}
