package com.biz.crm.dms.business.allow.sale.sdk.dimension.register;

import com.biz.crm.dms.business.allow.sale.sdk.dimension.Dimension;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用于允销规则维度注册
 *
 * @author sunx
 * @date 2021/11/23
 */
public interface AllowSaleRuleDimensionRegister<T extends Dimension> {

  /**
   * 维度系统编码，系统唯一，非常重要
   *
   * @return
   */
  String getType();

  /**
   * 维度中文描述,用于前端展示，非常重要
   *
   * @return
   */
  String getTypeDesc();

  /**
   * 显示排序
   *
   * @return
   */
  default int sort() {
    return -100;
  }

  /**
   * 返回T泛型子类信息，用于实体转换
   *
   * @return
   */
  Class<T> getDimensionClass();

  /**
   * 该维度对应维护可购清单的业务类型，如终端[terminal]、客户[customer]
   *
   * @return
   */
  String getListType();

  /**
   * 保存自定义维度配置信息，*注:入参是实现类的超类，需要实现的时候自己强转对应的子类
   *
   * <p>例如客户组织维度的配置（ruleCode - orgCode对应关系），可以新建扩展表存储规则对应维度配置信息
   *
   * @param dimension 维度信息
   */
  void saveDimensionDetail(Dimension dimension);

  /**
   * 根据允销规则编码获取维度详细配置信息
   *
   * <p>根据规则编码获取 saveDimensionDetail 存储的配置信息
   *
   * @param ruleCode 规则编码
   * @return
   */
  T findByRuleCode(String ruleCode);

  /**
   * 根据维度关联编码获取对应的规则编码集合
   *
   * <p>如存储了客户组织维度配置（ruleCode - orgCode对应关系），获取具体的对应关系
   *
   * @param relateCodeList 关联业务编码集合
   * @return k-relateCode , v-ruleCode集合
   */
  Map<String, Set<String>> findRelateRuleCodesMapByRelateCodes(List<String> relateCodeList);

  /**
   * 根据允销规则获取关联业务明细
   *
   * <p>根据规则编码获取配置信息，根据配置信息获取具体需要绑定到可购清单上的businessCode集合信息
   *
   * @param ruleCodeList 规则编码集合
   * @return k-ruleCode,v-可购清单纬度的businessCode集合（如终端编码、客户编码）
   */
  Map<String, Set<String>> findRuleRelateBusinessCodesMapByRuleCodes(List<String> ruleCodeList);
}
