package com.biz.crm.dms.business.allow.sale.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.Getter;

/**
 * 可购规则维度
 *
 * @author sunx
 * @date 2021/11/19
 */
@Getter
public enum AllowSaleDimensionTypeEnums {
  /** 可购规则维度 */
  CUSTOMER("customer", "客户"),
  CUSTOMER_ORG("customer_org", "组织(客户)"),
  TERMINAL("terminal", "终端"),
  TERMINAL_ORG("terminal_org", "组织(终端)"),
  ;
  private String code;
  private String desc;

  AllowSaleDimensionTypeEnums(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public static AllowSaleDimensionTypeEnums findByCode(String code) {
    Optional<AllowSaleDimensionTypeEnums> first =
        Stream.of(AllowSaleDimensionTypeEnums.values())
            .filter(a -> a.code.equals(code))
            .findFirst();
    return first.orElse(null);
  }
}
