package com.biz.crm.dms.business.allow.sale.sdk.enums;


import java.util.Optional;
import java.util.stream.Stream;
import lombok.Getter;

/**
 * @description: 可购清单类型
 * @author: rentao
 * @date: 2021/11/25 11:23
 */
@Getter
public enum AllowSaleElementEnums {

  /** 可购清单类型 */
  PRODUCT("product", "产品SKU"),
  PRODUCT_LEVEL("productLevel", "产品层级"),
  ;

  private String code;
  private String desc;

  AllowSaleElementEnums(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public static Boolean exists(String value) {
    Optional<AllowSaleElementEnums> first =
        Stream.of(AllowSaleElementEnums.values()).filter(a -> a.code.equals(value)).findFirst();
    return first.isPresent();
  }
}
