package com.biz.crm.dms.business.allow.sale.sdk.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 允销清单类型枚举
 *
 * @author sunx
 * @date 2021/11/19
 */
@Getter
public enum AllowSaleListTypeEnums {
  /** 允销清单类型枚举 */
  TERMINAL("terminal", "终端"),
  CUSTOMER("customer", "客户"),
  ;

  private String code;
  private String desc;

  AllowSaleListTypeEnums(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  /**
   * 根据可购规则维度获取对应的类型
   *
   * @param ruleType
   * @return
   */
  public static AllowSaleListTypeEnums findByRuleType(String ruleType) {
    if (StringUtils.isBlank(ruleType)) {
      return null;
    }
    if (ruleType.indexOf(AllowSaleListTypeEnums.TERMINAL.code) >= 0) {
      return AllowSaleListTypeEnums.TERMINAL;
    }
    if (ruleType.indexOf(AllowSaleListTypeEnums.CUSTOMER.code) >= 0) {
      return AllowSaleListTypeEnums.CUSTOMER;
    }
    return null;
  }
}
