package com.biz.crm.dms.business.allow.sale.sdk.enums;

import java.util.stream.Stream;
import lombok.Getter;

/**
 * 允销规则商品规则类型
 *
 * @author sunx
 * @date 2021/11/19
 */
@Getter
public enum AllowSaleRuleProductRelateTypeEnums {
  /** 允销规则商品规则类型 */
  PRODUCT("product", "产品"),
  SPU("spu", "spu编码"),
  PRODUCT_LEVEL("product_level", "产品层级"),
  ;
  private String code;
  private String desc;

  AllowSaleRuleProductRelateTypeEnums(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public static AllowSaleRuleProductRelateTypeEnums findByCode(String code) {
    return Stream.of(AllowSaleRuleProductRelateTypeEnums.values())
        .filter(a -> a.code.equals(code))
        .findFirst()
        .orElse(null);
  }
}
