package com.biz.crm.dms.business.allow.sale.sdk.list.dto;

import java.util.Optional;
import java.util.Set;
import lombok.Data;

/**
 * 维度信息变更更新可购清单明细dto
 *
 * @author sunx
 * @date 2021/11/24
 */
@Data
public class AllowSaleListDimensionItemDto {

  /** 维度编码，对应注册器(AllowSaleRuleDimensionRegister)的type值 */
  private String dimensionType;

  /** 纬度规则关联编码，如组织编码、终端编码、客户编码等，用于获取匹配的允销规则信息 */
  private String relateCode;

  /** 当前relateCode下级查询到应用到可购清单生成的businessCode集合，如终端编码、客户编码 */
  private Set<String> businessCodeList;

  /**
   * 验重使用
   *
   * @return
   */
  public String getRepeatKey() {
    return Optional.ofNullable(this.getDimensionType()).orElse("")
        + "-"
        + Optional.ofNullable(this.getRelateCode()).orElse("");
  }
}
