package com.biz.crm.dms.business.allow.sale.sdk.list.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 可购清单电商首页分页查询请求实体dto
 *
 * @author sunx
 * @date 2021/12/6
 */
@Data
@ApiModel(value = "AllowSaleListDmsPaginationDto", description = "可购清单电商首页分页查询请求实体dto")
public class AllowSaleListDmsPaginationDto {

  /** 业务编码,终端编码或客户编码 */
  @ApiModelProperty("业务编码，终端编码或客户编码")
  private String businessCode;

  /** 标签集合搜索过滤 */
  @ApiModelProperty("允销清单类型，终端或客户")
  private String listType;

  /** 搜索关键字，名称或编码 */
  @ApiModelProperty("搜索关键字，名称或编码")
  private String keyword;

  /** 产品层级 */
  @ApiModelProperty("产品层级，根据该过滤条件搜索当前及子级所有层级编码")
  private String productLevelCode;

  /** 标签集合搜索过滤 */
  @ApiModelProperty("标签集合搜索过滤，新品等")
  private List<String> spuTagList;
}
