package com.biz.crm.dms.business.allow.sale.sdk.list.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;

import java.util.List;

/**
 * 允销清单信息分页查询dto
 *
 * @author sunx
 * @date 2021-11-19 15:12:36
 */
@Data
@ApiModel(value = "AllowSaleListPaginationDto", description = "允销清单信息分页查询dto")
public class AllowSaleListPaginationDto extends TenantFlagOpDto {

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /** 允销清单类型，终端或客户 */
  @ApiModelProperty("允销清单类型，终端或客户，AllowSaleListTypeEnums，terminal-终端，customer-客户")
  private String listType;

  /**
   * 允销规则类型
   *
   * @see AllowSaleRuleTypeEnums
   */
  @ApiModelProperty("允销规则类型")
  private String ruleType;

  /** 业务编码，终端编码或客户编码 */
  @ApiModelProperty("业务编码，终端编码或客户编码")
  private String businessCode;

  /** 业务编码集合，终端编码或客户编码 */
  @ApiModelProperty("业务编码集合，终端编码或客户编码")
  private Set<String> businessCodeSet;

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  private String ruleCode;

  /** 商品编码集合 */
  @ApiModelProperty("商品编码集合")
  private List<String> productCodes;
}
