package com.biz.crm.dms.business.allow.sale.sdk.list.dto;

import java.util.Optional;
import java.util.Set;
import lombok.Data;

/**
 * 商品信息变更更新可购清单明细dto
 *
 * @author sunx
 * @date 2021/11/24
 */
@Data
public class AllowSaleListProductItemDto {

  /** 类型，AllowSaleRuleProductRelateTypeEnums，spu、product_level */
  private String relateType;

  /** 可购商品规则关联编码，如spu编码、产品层级编码 */
  private String relateCode;

  /** 当前relateCode下级查询到应用到可购清单生成的productCode集合，商品编码集合 */
  private Set<String> productCodeList;

  /**
   * 验重使用
   *
   * @return
   */
  public String getRepeatKey() {
    return Optional.ofNullable(this.getRelateType()).orElse("")
        + "-"
        + Optional.ofNullable(this.getRelateCode()).orElse("");
  }
}
